package ru.yandex.direct.api.v5.entity.bids.converter.get;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.BidGetItem;
import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.auction.container.bs.KeywordBidBsAuctionData;
import ru.yandex.direct.core.entity.bids.container.CompleteBidData;

import static ru.yandex.direct.api.v5.entity.bids.converter.get.BidGetItemWriterComposition.writerCompositionOf;
import static ru.yandex.direct.api.v5.entity.bids.converter.get.BsAuctionBidFieldWriter.createBsAuctionBidFieldWriter;
import static ru.yandex.direct.api.v5.entity.bids.converter.get.DirectBidFieldWriter.createDirectBidFieldWriter;
import static ru.yandex.direct.api.v5.entity.bids.converter.get.PokazometerBidFieldWriter.createPokazometerBidFieldWriter;

/**
 * Входная точка для преобразования полученной информации о ставках в список {@link BidGetItem} для ответа
 */
@ParametersAreNonnullByDefault
public class GetBidsConverter {

    private GetBidsConverter() {
    }

    public static List<BidGetItem> convertCompleteBidDataToBidGetItems(Set<BidFieldEnum> requiredFields,
                                                                       List<CompleteBidData<KeywordBidBsAuctionData>> completeBidData) {
        List<BidGetItem> result = new ArrayList<>(completeBidData.size());

        BidGetItemWriter writerComposition = writerCompositionOf(
                createDirectBidFieldWriter(requiredFields, completeBidData),
                createPokazometerBidFieldWriter(requiredFields, completeBidData),
                createBsAuctionBidFieldWriter(requiredFields, completeBidData)
        );

        StreamEx.of(completeBidData)
                .map(CompleteBidData::getBidId)
                .forEach((bidId) -> {
                    BidGetItem item = new BidGetItem();
                    writerComposition.write(item, bidId);
                    result.add(item);
                });

        return result;
    }

}
