package ru.yandex.direct.api.v5.entity.bids.service.validation;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.types.Identity;
import ru.yandex.direct.validation.result.Path;

public interface BidsDefectTranslations extends TranslationBundle {

    BidsDefectTranslations INSTANCE = I18NBundle.implement(BidsDefectTranslations.class);

    @MessageFormatStub("Не удалось найти ключевые слова для {0} = {1}")
    Translatable keywordNotFoundFor(String fieldName, Identity id);

    @MessageFormatStub("Хотя бы одно из следующих полей: {0} должно быть указано")
    Translatable requiredAtLeastOneOfFieldsDetailed(String fields);

    @MessageFormatStub("Одно из полей {0}, {1}, {2} должно быть указано")
    Translatable requiredAtLeastOneOfFieldsThreeElements(Path first, Path second, Path third);

    @MessageFormatStub("Для стратегии с независимым управлением ставками хотя бы одно из следующих полей должно быть указано: {0}")
    Translatable requiredAtLeastOneOfFieldsForManualStrategyDetailed(String fields);

    @MessageFormatStub("Для автоматической стратегии хотя бы одно из следующих полей должно быть указано: {0}")
    Translatable requiredAtLeastOneOfFieldsForAutobudgetStrategyDetailed(String fields);

    @MessageFormatStub("Одно из полей {0} должно быть указано")
    Translatable oneOfFieldsRequiredDetailed(String fields);

    @MessageFormatStub("Значение ставки в поле {0} для валюты \"{1}\" должно быть не меньше {2}")
    Translatable bidMustBeNotLessThan(String field, Translatable currency, Translatable amountInApi);

    @MessageFormatStub("Значение ставки в поле {0} для валюты \"{1}\" должно быть не больше {2}")
    Translatable bidMustBeNotGreaterThan(String field, Translatable currency, Translatable amountInApi);

    @MessageFormatStub("Для автоматической стратегии поле {0} должно быть указано")
    Translatable fieldDoesNotMatchStrategy(String fieldName);

    @MessageFormatStub("Поле не соответствует установленной стратегии")
    Translatable fieldDoesNotMatchStrategyShort();

    @MessageFormatStub("Для обновления ставок на поиске необходимо указать {0}")
    Translatable fieldRequiredForSearchStrategy(String field);

    @MessageFormatStub("Для обновления ставок на сети необходимо указать {0}")
    Translatable fieldRequiredForContextStrategy(String field);

    @MessageFormatStub("Для обновления ставок на поиске необходимо указать {0} если задан {1}")
    Translatable dependentFieldMissing(String dependentField, String field);

    @MessageFormatStub("Ставки на поиске не будут изменены, так как отключены показы на поиске")
    Translatable bidChangeNotAllowedSearchIsSwitchedOff();

    @MessageFormatStub("Изменение ставок на сети не разрешено, так как показы на сети отключены")
    Translatable bidChangeNotAllowedContextIsSwitchedOff();

    @MessageFormatStub("Изменение ставок на сети не разрешено, так как установлена стратегия, при которой ставка на сети зависит от ставки на поиске")
    Translatable bidChangeNotAllowedContextDependsOnSearch();

    @MessageFormatStub("Для стратегии с ручным управлением ставками на поиске поле {0} должно быть указано")
    Translatable searchPriceMustBeSetForManualStrategy(Path path);

    @MessageFormatStub("Для стратегии с ручным управлением ставками на сети поле {0} должно быть указано")
    Translatable contextPriceMustBeSetForManualStrategy(Path path);

    @MessageFormatStub("Для автоматической стратегии поле {0} должно быть указано")
    Translatable fieldMustBeSetForAutobudgetStrategy(Path path);

    @MessageFormatStub("Разрешена установка ставок не более чем для {0} ключевых слов в одном запросе")
    Translatable maxElementsPerRequestBidsIdsDetailed(Identity limit);

    @MessageFormatStub("Разрешена установка ставок не более чем для {0} групп объявлений в одном запросе")
    Translatable maxElementsPerRequestBidsAdGroupIdsDetailed(Identity limit);

    @MessageFormatStub("Разрешена установка ставок не более чем для {0} кампаний в одном запросе")
    Translatable maxElementsPerRequestBidsCampaignIdsDetailed(Identity limit);

    @MessageFormatStub("KeywordId = {0} является автотаргетингом и не может быть использован в конструкторе ставок")
    Translatable relevanceMatchCantBeUsedInPriceConstructor(Identity limit);

    @MessageFormatStub("Не допускается изменение ставки")
    Translatable bidChangeNotAllowedShort();

    @MessageFormatStub("У кампании установлена автобюджетная стратегия")
    Translatable autobudgetStrategyIsSetForCampaign();

    @MessageFormatStub("Ставка не будет применена")
    Translatable bidWontBeAccepted();

    @MessageFormatStub("Ставка {0} не будет применена, так как не установлена стратегия")
    Translatable bidWontBeAcceptedStrategyIsNotSet(Path path);

    @MessageFormatStub("Ставка {0} не будет применена, так как установлена стратегия, при которой ставка на сети зависит от ставки на поиске")
    Translatable bidWontBeAcceptedContextDependsSearch(Path path);

    @MessageFormatStub("Ставка {0} не будет применена, так как установлена автобюджетная стратегия")
    Translatable bidWontBeAcceptedInCaseOfAutoBudgetStrategy(Path path);

    @MessageFormatStub("Ставки на сети не будут изменены, так как установлена стратегия, при которой ставка на сети зависит от ставки на поиске")
    Translatable bidWontBeAcceptedContextDependsOnSearch();

    @MessageFormatStub("Ставки на сети не будут изменены, так как установлена стратегия, при которой ставка на сети зависит от ставки на поиске")
    Translatable networkBidWontBeAcceptedContextDependsOnSearch();

    @MessageFormatStub("Ставки на сети не будут изменены, так как отключены показы на сети")
    Translatable bidWontBeAcceptedContextIsSwitchedOff();

    @MessageFormatStub("Ставки на поиске не будут изменены, так как отключены показы на поиске")
    Translatable bidWontBeAcceptedSearchIsSwitchedOff();

    @MessageFormatStub("Ставки на поиске не будут изменены, так как отключены показы на поиске")
    Translatable searchBidsWontBeAcceptedSearchIsSwitchedOff();

    @MessageFormatStub("Приоритет не будет применен")
    Translatable priorityWontBeAccepted();

    @MessageFormatStub("Значение {0} не будет применено, так как установлена стратегия с ручным управлением")
    Translatable priorityWontBeAcceptedForManualStrategy(Path path);

    @MessageFormatStub("Ставки на поиске не будут изменены, так как отключены показы на поиске")
    Translatable searchBidWontBeAcceptedSearchIsSwitchedOff();

    @MessageFormatStub("Ставки на сети не будут изменены, так как установлена стратегия, при которой ставка на сети зависит от ставки на поиске")
    Translatable bidNetworkWontBeAcceptedContextDependsOnSearch();

    @MessageFormatStub("Ставка {0} не будет применена, так как отключены показы на сети")
    Translatable bidWontBeAcceptedContextIsServingOff(Path path);
}
