package ru.yandex.direct.api.v5.entity.bids.service.validation;

import ru.yandex.direct.api.v5.common.validation.DefectPresentationsHolder;
import ru.yandex.direct.api.v5.entity.bids.validation.BidsDefectPresentations;
import ru.yandex.direct.core.entity.bids.validation.BidsDefects;

import static ru.yandex.direct.api.v5.entity.bids.validation.BidsDefectTypes.bidWontBeAccepted;

public class SetAutoBidsDefectPresentations {
    public static final DefectPresentationsHolder HOLDER = DefectPresentationsHolder
            .builderWithFallback(BidsDefectPresentations.HOLDER)
            .register(BidsDefects.Ids.BID_FOR_SEARCH_WONT_BE_ACCEPTED_SEARCH_IS_SWITCHED_OFF,
                    t -> bidWontBeAccepted().withDetailedMessage(translations().searchBidsWontBeAcceptedSearchIsSwitchedOff()))
            .register(BidsDefects.Ids.BID_FOR_CONTEXT_WONT_BE_ACCEPTED_NOT_DIFFERENT_PLACES,
                    t -> bidWontBeAccepted().withDetailedMessage(translations().networkBidWontBeAcceptedContextDependsOnSearch()))

            .build();

    private static BidsDefectTranslations translations() {
        return BidsDefectTranslations.INSTANCE;
    }
}
