package ru.yandex.direct.api.v5.entity.businesses;

import com.yandex.direct.api.v5.businesses.ApiException;
import com.yandex.direct.api.v5.businesses.BusinessesPort;
import com.yandex.direct.api.v5.businesses.GetRequest;
import com.yandex.direct.api.v5.businesses.GetResponse;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.api.v5.entity.GenericApiService;
import ru.yandex.direct.api.v5.entity.businesses.delegate.GetBusinessesDelegate;
import ru.yandex.direct.api.v5.ws.annotation.ApiMethod;
import ru.yandex.direct.api.v5.ws.annotation.ApiRequest;
import ru.yandex.direct.api.v5.ws.annotation.ApiResponse;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceEndpoint;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceType;
import ru.yandex.direct.api.v5.ws.annotation.ServiceType;
import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;

@ApiServiceEndpoint
@ApiServiceType(type = ServiceType.CLIENT)
public class BusinessesEndpoint implements BusinessesPort {

    private static final String SERVICE_NAME = "businesses";

    private final GenericApiService genericApiService;
    private final GetBusinessesDelegate getBusinessesDelegate;

    @Autowired
    public BusinessesEndpoint(GenericApiService genericApiService, GetBusinessesDelegate getBusinessesDelegate) {
        this.genericApiService = genericApiService;
        this.getBusinessesDelegate = getBusinessesDelegate;
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "get")
    @ApiResponse
    @Override
    public GetResponse get(@ApiRequest GetRequest getRequest) throws ApiException {
        return genericApiService.doAction(getBusinessesDelegate, getRequest);
    }
}
