package ru.yandex.direct.api.v5.entity.businesses.converter;

import java.util.List;
import java.util.Optional;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.businesses.BusinessGetItem;
import com.yandex.direct.api.v5.businesses.ObjectFactory;
import com.yandex.direct.api.v5.general.ArrayOfLong;
import com.yandex.direct.api.v5.general.ArrayOfString;

import ru.yandex.direct.organizations.swagger.OrganizationApiInfo;
import ru.yandex.direct.organizations.swagger.model.Address;
import ru.yandex.direct.organizations.swagger.model.CompanyPhone;
import ru.yandex.direct.organizations.swagger.model.LocalizedString;

import static com.yandex.direct.api.v5.general.YesNoEnum.NO;
import static com.yandex.direct.api.v5.general.YesNoEnum.YES;
import static org.apache.commons.collections4.CollectionUtils.isEmpty;
import static ru.yandex.direct.core.entity.organization.model.OrganizationStatusPublish.PUBLISHED;

@ParametersAreNonnullByDefault
public class GetBusinessesResponseConverter {
    private static final ObjectFactory FACTORY = new ObjectFactory();

    public static BusinessGetItem convert(OrganizationApiInfo organizationInfo) {
        return FACTORY.createBusinessGetItem()
                .withId(organizationInfo.getPermalinkId())
                .withName(organizationInfo.getCompanyName())
                .withAddress(FACTORY.createBusinessGetItemAddress(Optional.ofNullable(organizationInfo.getAddress())
                        .map(Address::getFormatted).map(LocalizedString::getValue).orElse(null)))
                .withPhone(Optional.ofNullable(organizationInfo.getPhone())
                        .map(CompanyPhone::getFormatted).orElse(null))
                .withProfileUrl(organizationInfo.getProfileUrl())
                .withInternalUrl(organizationInfo.getCabinetUrl())
                .withMergedIds(createMergedIds(organizationInfo.getMergedPermalinks()))
                .withIsPublished(organizationInfo.getStatusPublish() == PUBLISHED ? YES : NO)
                .withRubric(organizationInfo.getRubric())
                .withUrls(createUrls(organizationInfo.getUrls()))
                .withHasOffice(Optional.ofNullable(organizationInfo.getIsOnline()).orElse(false) ? NO : YES);
    }

    private static JAXBElement<ArrayOfLong> createMergedIds(Set<Long> mergedPermalinks) {
        return FACTORY.createBusinessGetItemMergedIds(
            isEmpty(mergedPermalinks)
                ? null
                : new ArrayOfLong().withItems(mergedPermalinks));
    }

    private static JAXBElement<ArrayOfString> createUrls(List<String> urls) {
        return FACTORY.createBusinessGetItemUrls(
            isEmpty(urls)
                ? null
                : new ArrayOfString().withItems(urls));
    }
}
