package ru.yandex.direct.api.v5.entity.businesses.validation;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.businesses.GetRequest;
import com.yandex.direct.api.v5.general.IdsCriteria;

import ru.yandex.direct.api.v5.common.validation.GetRequestGeneralValidator;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.ValidationResult;

import static com.yandex.direct.api.v5.businesses.GetRequest.PropInfo.SELECTION_CRITERIA;
import static com.yandex.direct.api.v5.general.IdsCriteria.PropInfo.IDS;
import static ru.yandex.direct.api.v5.common.constants.GetRequestCommonConstants.DEFAULT_MAX_IDS_COUNT;
import static ru.yandex.direct.api.v5.validation.constraints.Constraints.eachNotNull;
import static ru.yandex.direct.api.v5.validation.constraints.Constraints.maxListSize;

@ParametersAreNonnullByDefault
public class GetBusinessesValidationService {

    @Nullable
    public static ValidationResult<GetRequest, DefectType> validateRequest(GetRequest externalRequest) {
        ItemValidationBuilder<GetRequest, DefectType> vb = ItemValidationBuilder.of(externalRequest);

        vb.checkBy(GetRequestGeneralValidator::validateRequestWithDefectTypes);

        vb.item(externalRequest.getSelectionCriteria(), SELECTION_CRITERIA.schemaName.toString())
                .checkBy(GetBusinessesValidationService::validateSelectionCriteria, When.notNull());

        return vb.getResult();
    }

    @Nullable
    private static ValidationResult<IdsCriteria, DefectType> validateSelectionCriteria(IdsCriteria selectionCriteria) {
        ItemValidationBuilder<IdsCriteria, DefectType> vb = ItemValidationBuilder.of(selectionCriteria);

        vb.item(selectionCriteria.getIds(), IDS.schemaName.toString())
                .check(maxListSize(DEFAULT_MAX_IDS_COUNT))
                .check(eachNotNull());

        return vb.getResult();
    }
}
