package ru.yandex.direct.api.v5.entity.campaigns;

import java.math.BigDecimal;

import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.api.v5.validation.DefectTypes;
import ru.yandex.direct.core.entity.campaign.model.Campaign;
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectTranslations;
import ru.yandex.direct.core.validation.CommonDefectTranslations;
import ru.yandex.direct.i18n.types.DummyTranslatable;
import ru.yandex.direct.i18n.types.Identity;

import static ru.yandex.direct.api.v5.validation.DefectTypes.badParams;
import static ru.yandex.direct.api.v5.validation.DefectTypes.cannotExtractObjectFromArchive;
import static ru.yandex.direct.api.v5.validation.DefectTypes.duplicatedArrayItem;
import static ru.yandex.direct.api.v5.validation.DefectTypes.duplicatedObject;
import static ru.yandex.direct.api.v5.validation.DefectTypes.inconsistentState;
import static ru.yandex.direct.api.v5.validation.DefectTypes.invalidUseOfField;
import static ru.yandex.direct.api.v5.validation.DefectTypes.invalidValue;
import static ru.yandex.direct.api.v5.validation.DefectTypes.maxElementsExceeded;
import static ru.yandex.direct.api.v5.validation.DefectTypes.maxElementsPerRequest;
import static ru.yandex.direct.api.v5.validation.DefectTypes.mutuallyExclusiveParameters;
import static ru.yandex.direct.api.v5.validation.DefectTypes.noRights;
import static ru.yandex.direct.api.v5.validation.DefectTypes.notFound;
import static ru.yandex.direct.api.v5.validation.DefectTypes.notSupported;
import static ru.yandex.direct.api.v5.validation.DefectTypes.parameterWillNotBeApplied;
import static ru.yandex.direct.api.v5.validation.DefectTypes.requiredButEmpty;
import static ru.yandex.direct.api.v5.validation.DefectTypes.settingWillNotBeChanged;
import static ru.yandex.direct.api.v5.validation.DefectTypes.unableToArchiveCampaignWithMoney;
import static ru.yandex.direct.api.v5.validation.DefectTypes.unableToArchiveNonStoppedCampaign;
import static ru.yandex.direct.api.v5.validation.DefectTypes.warningAlreadyArchived;
import static ru.yandex.direct.api.v5.validation.DefectTypes.warningAlreadySuspended;
import static ru.yandex.direct.api.v5.validation.DefectTypes.warningNotArchived;
import static ru.yandex.direct.api.v5.validation.DefectTypes.warningNotSuspended;

public class CampaignDefectTypes {
    private CampaignDefectTypes() {
    }

    public static DefectType archivedCampaignModification() {
        return DefectTypes.badStatus().withDetailedMessage(commonTranslations().cantEditArchivedCampaignDetailed());
    }

    public static DefectType campaignNoRights() {
        return noRights().withDetailedMessage(commonTranslations().noRightsCantWrite());
    }

    public static DefectType campaignNotFound() {
        return notFound().withDetailedMessage(commonTranslations().campaignNotFound());
    }

    public static DefectType wrongDisableDomainLimit() {
        return badParams().withDetailedMessage(commonTranslations().wrongDisabledDomainsLimit());
    }

    public static DefectType campaignTypeNotSupported() {
        return notSupported()
                .withDetailedMessage(commonTranslations().campaignTypeNotSupportedDetailed());
    }

    public static DefectType campaignWithMoneyArchiving() {
        return unableToArchiveCampaignWithMoney()
                .withDetailedMessage(commonTranslations().campaignWithMoneyArchivingDetailed());
    }

    public static DefectType nonStoppedCampaignArchiving() {
        return unableToArchiveNonStoppedCampaign()
                .withDetailedMessage(commonTranslations().nonStoppedCampaignArchivingDetailed());
    }

    public static DefectType campaignAlreadyArchived() {
        return warningAlreadyArchived()
                .withDetailedMessage(commonTranslations().campaignAlreadyArchivedDetailed());
    }

    public static DefectType campaignNotArchived() {
        return warningNotArchived()
                .withDetailedMessage(commonTranslations().campaignNotArchivedDetailed());
    }

    public static DefectType unarcCampaignsLimitExceeded(long limit) {
        return cannotExtractObjectFromArchive()
                .withDetailedMessage(commonTranslations().unarcCampaignsLimitExceededDetailed(new Identity(limit)));
    }

    public static DefectType campaignAlreadySuspended() {
        return warningAlreadySuspended()
                .withDetailedMessage(commonTranslations().campaignAlreadySuspendedDetailed());
    }

    public static DefectType campaignNotSuspended() {
        return warningNotSuspended()
                .withDetailedMessage(commonTranslations().campaignNotSuspendedDetailed());
    }

    public static DefectType minusKeywordsNotAllowed() {
        return inconsistentState().withDetailedMessage(commonTranslations().minusKeywordsAreNotAllowedForCampaign());
    }

    public static DefectType searchStrategyHasMoreThanOneStructureWithSettings() {
        return badParams().withDetailedMessage(
                commonTranslations().searchStrategyHasMoreThanOneStructureWithSettings());
    }

    public static DefectType networkStrategyHasMoreThanOneStructureWithSettings() {
        return badParams().withDetailedMessage(
                commonTranslations().networkStrategyHasMoreThanOneStructureWithSettings());
    }

    public static DefectType structureForSearchStrategyDoesNotMatchStrategyName() {
        return badParams().withDetailedMessage(
                commonTranslations().structureForSearchStrategyDoesNotMatchStrategyName());
    }

    public static DefectType structureForNetworkStrategyDoesNotMatchStrategyName() {
        return badParams().withDetailedMessage(
                commonTranslations().structureForNetworkStrategyDoesNotMatchStrategyName());
    }

    public static DefectType searchStrategyMustContainStructureWithSettings(String strategyType) {
        return badParams().withDetailedMessage(
                commonTranslations().searchStrategyMustContainStructureWithSettings(strategyType));
    }

    public static DefectType networkStrategyMustContainStructureWithSettings(String strategyType) {
        return badParams().withDetailedMessage(
                commonTranslations().networkStrategyMustContainStructureWithSettings(strategyType));
    }

    public static DefectType impressionsBelowSearchStrategyIsNotSupported() {
        return notSupported().withDetailedMessage(
                commonTranslations().impressionsBelowSearchStrategyIsNotSupported());
    }

    public static DefectType weeklyClickPackageNotSupported() {
        return invalidUseOfField()
                .withDetailedMessage(CampaignDefectTranslations.INSTANCE.weeklyClickPackageNotSupported());
    }

    public static DefectType strategiesAreNotCompatible() {
        return badParams().withDetailedMessage(
                commonTranslations().strategiesAreNotCompatible());
    }

    public static CommonDefectTranslations commonTranslations() {
        return CommonDefectTranslations.INSTANCE;
    }

    public static CampaignDefectTranslations campaignTranslations() {
        return CampaignDefectTranslations.INSTANCE;
    }

    public static DefectType maxCampaignsForClientId(Integer maxCampaignsForClientId) {
        return maxElementsExceeded(maxCampaignsForClientId)
                .withDetailedMessage(campaignTranslations()
                        .maxCampaignsForClientDetailed(new Identity(maxCampaignsForClientId)));
    }

    public static DefectType campaignIsInSpecialArchivedState() {
        return cannotExtractObjectFromArchive().withDetailedMessage((path, value) -> {
            String campaignId = value instanceof Campaign ? ((Campaign) value).getId().toString() : "";
            return commonTranslations().campaignIsInSpecialArchivedState(campaignId);
        });
    }

    public static DefectType maxCampaignsPerAddRequest(Integer count) {
        return maxElementsPerRequest(count)
                .withDetailedMessage(CampaignDefectTranslations.INSTANCE
                        .maxCampaignsPerAddRequestDetailed(new Identity(count)));
    }

    public static DefectType maxCampaignsPerUpdateRequest(Integer count) {
        return maxElementsPerRequest(count)
                .withDetailedMessage(CampaignDefectTranslations.INSTANCE
                        .maxCampaignsPerUpdateRequestDetailed(new Identity(count)));
    }

    public static DefectType networkDefaultLimitPercentNotInRange() {
        return invalidValue()
                .withDetailedMessage(CampaignDefectTranslations.INSTANCE
                        .networkDefaultLimitPercentNotInRange());
    }

    public static DefectType networkDefaultLimitPercentNotMultiple(Integer multiplicity) {
        return invalidValue()
                .withDetailedMessage(CampaignDefectTranslations.INSTANCE
                        .networkDefaultLimitPercentNotMultiple(new Identity(multiplicity)));
    }

    public static DefectType arrayElementContainsBlankString(String arrayName) {
        return invalidValue()
                .withDetailedMessage(CommonDefectTranslations.INSTANCE
                        .arrayElementContainsBlankString(arrayName));
    }

    public static DefectType timeZoneDoesntExist() {
        return badParams().withDetailedMessage(commonTranslations().timeZoneDoesntExist());
    }

    public static DefectType timeTargetingDayOfTheWeekOutOfRange() {
        return invalidValue()
                .withDetailedMessage(CampaignDefectTranslations.INSTANCE
                        .timeTargetingDayOfTheWeekOutOfRange());
    }

    public static DefectType timeTargetingDayOfTheWeekHasDuplicates() {
        return duplicatedArrayItem()
                .withDetailedMessage(CampaignDefectTranslations.INSTANCE
                        .timeTargetingDayOfTheWeekContainsDuplicates());
    }

    public static DefectType timeTargetingBidsIncomplete() {
        return invalidValue()
                .withDetailedMessage(CampaignDefectTranslations.INSTANCE
                        .timeTargetingBidsIncomplete());
    }

    public static DefectType timeTargetingBidsMustNotBeNegative() {
        return invalidValue()
                .withDetailedMessage(CampaignDefectTranslations.INSTANCE
                        .timeTargetingBidsMustNotBeNegative());
    }

    public static DefectType timeTargetingBidsInCpmBannerCampaignMustBeOnOrOff() {
        return invalidValue()
                .withDetailedMessage(CampaignDefectTranslations.INSTANCE
                        .timeTargetingBidsInCpmBannerCampaignMustBeOnOrOff());
    }

    public static DefectType timeTargetingBidsMustDevideTen() {
        return invalidValue()
                .withDetailedMessage(CampaignDefectTranslations.INSTANCE
                        .timeTargetingBidsMustDevideTen());
    }

    public static DefectType timeTargetingBidsOutOfRange() {
        return invalidValue()
                .withDetailedMessage(CampaignDefectTranslations.INSTANCE
                        .timeTargetingBidsOutOfRange());
    }

    public static DefectType timeTargetingBidsAreNotIntegers() {
        return invalidValue()
                .withDetailedMessage(CampaignDefectTranslations.INSTANCE
                        .timeTargetingBidsAreNotIntegers());
    }

    public static DefectType holidaysScheduleCantContainStartHourWhenSuspendOnHolidaysYes() {
        return badParams()
                .withDetailedMessage(CampaignDefectTranslations.INSTANCE
                        .holidaysScheduleCantContainStartHourWhenSuspendOnHolidaysYes());
    }

    public static DefectType holidaysScheduleCantContainEndHourWhenSuspendOnHolidaysYes() {
        return badParams()
                .withDetailedMessage(CampaignDefectTranslations.INSTANCE
                        .holidaysScheduleCantContainEndHourWhenSuspendOnHolidaysYes());
    }

    public static DefectType holidaysScheduleCantContainBidPercentWhenSuspendOnHolidaysYes() {
        return badParams()
                .withDetailedMessage(CampaignDefectTranslations.INSTANCE
                        .holidaysScheduleCantContainBidPercentWhenSuspendOnHolidaysYes());
    }

    public static DefectType holidayBidPercentMustBeOneHundredInCpmBannerCampaign() {
        return badParams()
                .withDetailedMessage(CampaignDefectTranslations.INSTANCE
                        .holidayBidPercentMustBeOneHundredInCpmBannerCampaign());
    }

    public static DefectType holidayBidPercentOutOfRange() {
        return badParams()
                .withDetailedMessage(campaignTranslations().holidayBidPercentOutOfRange());
    }

    public static DefectType holidayBidPercentMustDevideTen() {
        return badParams()
                .withDetailedMessage(campaignTranslations().holidayBidPercentMustDevideTen());
    }

    public static DefectType startHourAndEndHourMustBeSetWhenSuspendOnHolidaysNotYes() {
        return requiredButEmpty()
                .withDetailedMessage(campaignTranslations()
                        .startHourAndEndHourMustBeSetWhenSuspendOnHolidaysNotYes());
    }

    public static DefectType startHourMustBeLessThanEndHour() {
        return invalidValue()
                .withDetailedMessage(campaignTranslations().startHourMustBeLessThanEndHour());
    }

    public static DefectType startHourOutOfRange() {
        return invalidValue()
                .withDetailedMessage(campaignTranslations().startHourOutOfRange());
    }

    public static DefectType endHourOutOfRange() {
        return invalidValue()
                .withDetailedMessage(campaignTranslations().endHourOutOfRange());
    }

    public static DefectType placementTypesAllDisabled() {
        return invalidValue()
                .withDetailedMessage(campaignTranslations().placementTypesAllDisabled());
    }

    public static DefectType negativeKeywordsAreNotAllowedInCpmBannerCampaign() {
        return inconsistentState()
                .withDetailedMessage(CampaignDefectTranslations.INSTANCE
                        .negativeKeywordsAreNotAllowedInCpmBannerCampaign());
    }

    public static DefectType avgBidAndBidTogetherAreProhibited() {
        return mutuallyExclusiveParameters()
                .withDetailedMessage(CampaignDefectTranslations.INSTANCE
                        .avgBidAndBidTogetherAreProhibited());
    }

    public static DefectType dayBudgetCanBeUsedWithManualStrategiesOnly() {
        return inconsistentState()
                .withDetailedMessage(CampaignDefectTranslations.INSTANCE
                        .dayBudgetCanBeUsedWithManualStrategiesOnly());
    }

    public static DefectType settingIsDeprecated(String setting) {
        return settingWillNotBeChanged()
                .withDetailedMessage(CommonDefectTranslations.INSTANCE
                        .settingIsDeprecated(setting));
    }

    public static DefectType settingInconsistentWithStrategy(String setting) {
        return settingWillNotBeChanged()
                .withDetailedMessage(CampaignDefectTranslations.INSTANCE
                        .settingInconsistentWithStrategy(setting));
    }

    public static DefectType requireServicingWillBeIgnored() {
        return settingWillNotBeChanged()
                .withDetailedMessage(CampaignDefectTranslations.INSTANCE
                        .requireServicingWillBeIgnored());
    }

    public static DefectType parameterInconsistentWithStrategy(String parameter) {
        return parameterWillNotBeApplied()
                .withDetailedMessage(CampaignDefectTranslations.INSTANCE
                        .parameterInconsistentWithStrategy(parameter));
    }

    public static DefectType inconsistentStateEndDateMustBeGreaterThanOrEqualToStartDate() {
        return inconsistentState().withDetailedMessage(
                (path, value) -> CampaignDefectTranslations.INSTANCE.endDateMustBeGreaterThanOrEqualToStartDate());
    }

    public static DefectType badParamsStrategyStartDateMustBeGreaterThanOrEqualToCampaignStartDate() {
        return badParams().withDetailedMessage(
                (path, value) -> CampaignDefectTranslations.INSTANCE
                        .strategyStartDateMustBeGreaterThanOrEqualToCampaignStartDate());
    }

    public static DefectType badParamsStrategyEndDateMustBeLessThanOrEqualToCampaignEndDate() {
        return badParams().withDetailedMessage(
                (path, value) -> CampaignDefectTranslations.INSTANCE
                        .strategyEndDateMustBeLessThanOrEqualToCampaignEndDate());
    }

    public static DefectType badParamsStrategyPeriodDaysCountLessThanMin(Integer min) {
        return badParams().withDetailedMessage(
                (path, value) -> CampaignDefectTranslations.INSTANCE
                        .strategyPeriodDaysCountLessThanMin(min));
    }

    public static DefectType badParamsStrategyPeriodDaysCountGreaterThanMax(Integer max) {
        return badParams().withDetailedMessage(
                (path, value) -> campaignTranslations()
                        .strategyPeriodDaysCountGreaterThanMax(max));
    }

    public static DefectType badParamsCpmPriceIsNotGreaterThanMin(BigDecimal min) {
        return badParams().withDetailedMessage(
                (path, value) -> campaignTranslations()
                        .cpmPriceIsNotGreaterThanMin(new DummyTranslatable(min.toString())));
    }

    public static DefectType badParamsCpmPriceIsNotSmallerThanMax(BigDecimal min) {
        return badParams().withDetailedMessage(
                (path, value) -> campaignTranslations()
                        .cpmPriceIsNotSmallerThanMax(new DummyTranslatable(min.toString())));
    }

    public static DefectType badParamsIncorrectSetOfMobileGoals() {
        return badParams().withDetailedMessage(
                (path, value) -> campaignTranslations()
                        .incorrectSetOfMobileGoals());
    }

    public static DefectType badParamsToOptimizeForMeaningfulGoalAtLeastOneGoalExceptEngagedSessionIsRequired() {
        return badParams().withDetailedMessage(
                (path, value) -> campaignTranslations()
                        .toOptimizeForMeaningfulGoalAtLeastOneGoalExceptEngagedSessionIsRequired());
    }

    public static DefectType badParamsFieldNotSupportedInCampaign(String field) {
        return badParams().withDetailedMessage(
                campaignTranslations().fieldIsNotSupportedInCampaign(field));
    }

    public static DefectType priorityGoalsNotSupportedOperation() {
        return notSupported().withDetailedMessage(campaignTranslations().priorityGoalsNotSupportedOperationDetailed());
    }

    public static DefectType goalIdNotSet() {
        return badParams().withDetailedMessage(campaignTranslations().goalIdNotSet());
    }

    public static DefectType campaignTypeNotMatchesWithTypeInRequest(String typeFromDb, String typeFromRequest) {
        return badParams().withDetailedMessage(
                campaignTranslations().campaignTypeNotMatchesWithTypeInRequest(typeFromDb, typeFromRequest));
    }

    public static DefectType duplicatedCampaign() {
        return duplicatedObject().withDetailedMessage(commonTranslations().duplicatedCampaignId());
    }

    public static DefectType relevantKeywordsUselessForChosenStrategy() {
        return new DefectType(10173,
                campaignTranslations().relevantKeywordsDisabled(),
                campaignTranslations().relevantKeywordsUselessForChosenStrategy());
    }

    public static DefectType warningNewStrategyHasBeenCreated() {
        return new DefectType(10166,
                campaignTranslations().newStrategyHasBeenCreated()
        );
    }

}
