package ru.yandex.direct.api.v5.entity.campaigns.container

import ru.yandex.direct.core.entity.campaign.model.BaseCampaign
import java.util.IdentityHashMap
import javax.annotation.ParametersAreNonnullByDefault

@ParametersAreNonnullByDefault
class AddCampaignsDelegateContainer {

    private val requireServicingMap: MutableMap<BaseCampaign, Boolean> = IdentityHashMap()

    fun addRequireServicing(campaign: BaseCampaign, requireServicing: Boolean) {
        requireServicingMap[campaign] = requireServicing
    }
    
    fun getRequireServicing(campaign: BaseCampaign): Boolean? = requireServicingMap[campaign]

}