package ru.yandex.direct.api.v5.entity.campaigns.container

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum
import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignFieldEnum
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignFieldEnum
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignFieldEnum
import com.yandex.direct.api.v5.campaigns.SmartCampaignFieldEnum
import com.yandex.direct.api.v5.campaigns.TextCampaignFieldEnum

enum class CampaignAnyFieldEnum(
    fieldName: String,
) {
    BLOCKED_IPS("BLOCKED_IPS"),
    EXCLUDED_SITES("EXCLUDED_SITES"),
    CURRENCY("CURRENCY"),
    DAILY_BUDGET("DAILY_BUDGET"),
    NOTIFICATION("NOTIFICATION"),
    END_DATE("END_DATE"),
    FUNDS("FUNDS"),
    CLIENT_INFO("CLIENT_INFO"),
    ID("ID"),
    NAME("NAME"),
    NEGATIVE_KEYWORDS("NEGATIVE_KEYWORDS"),
    REPRESENTED_BY("REPRESENTED_BY"),
    START_DATE("START_DATE"),
    STATISTICS("STATISTICS"),
    STATE("STATE"),
    STATUS("STATUS"),
    STATUS_PAYMENT("STATUS_PAYMENT"),
    STATUS_CLARIFICATION("STATUS_CLARIFICATION"),
    SOURCE_ID("SOURCE_ID"),
    TIME_TARGETING("TIME_TARGETING"),
    TIME_ZONE("TIME_ZONE"),
    TYPE("TYPE"),

    CONTENT_PROMOTION_CAMPAIGN_COUNTER_IDS("COUNTER_IDS"),
    CONTENT_PROMOTION_CAMPAIGN_SETTINGS("SETTINGS"),
    CONTENT_PROMOTION_CAMPAIGN_BIDDING_STRATEGY("BIDDING_STRATEGY"),
    CONTENT_PROMOTION_CAMPAIGN_ATTRIBUTION_MODEL("ATTRIBUTION_MODEL"),

    CPM_BANNER_CAMPAIGN_COUNTER_IDS("COUNTER_IDS"),
    CPM_BANNER_CAMPAIGN_FREQUENCY_CAP("FREQUENCY_CAP"),
    CPM_BANNER_CAMPAIGN_VIDEO_TARGET("VIDEO_TARGET"),
    CPM_BANNER_CAMPAIGN_SETTINGS("SETTINGS"),
    CPM_BANNER_CAMPAIGN_BIDDING_STRATEGY("BIDDING_STRATEGY"),

    DYNAMIC_TEXT_CAMPAIGN_PLACEMENT_TYPES("PLACEMENT_TYPES"),
    DYNAMIC_TEXT_CAMPAIGN_COUNTER_IDS("COUNTER_IDS"),
    DYNAMIC_TEXT_CAMPAIGN_SETTINGS("SETTINGS"),
    DYNAMIC_TEXT_CAMPAIGN_BIDDING_STRATEGY("BIDDING_STRATEGY"),
    DYNAMIC_TEXT_CAMPAIGN_PRIORITY_GOALS("PRIORITY_GOALS"),
    DYNAMIC_TEXT_CAMPAIGN_ATTRIBUTION_MODEL("ATTRIBUTION_MODEL"),
    DYNAMIC_TEXT_CAMPAIGN_STRATEGY_ID("STRATEGY_ID"),
    DYNAMIC_TEXT_CAMPAIGN_TRACKING_PARAMS("TRACKING_PARAMS"),

    MOBILE_APP_CAMPAIGN_SETTINGS("SETTINGS"),
    MOBILE_APP_CAMPAIGN_BIDDING_STRATEGY("BIDDING_STRATEGY"),
    MOBILE_APP_CAMPAIGN_STRATEGY_ID("STRATEGY_ID"),

    SMART_CAMPAIGN_COUNTER_ID("COUNTER_ID"),
    SMART_CAMPAIGN_SETTINGS("SETTINGS"),
    SMART_CAMPAIGN_BIDDING_STRATEGY("BIDDING_STRATEGY"),
    SMART_CAMPAIGN_PRIORITY_GOALS("PRIORITY_GOALS"),
    SMART_CAMPAIGN_ATTRIBUTION_MODEL("ATTRIBUTION_MODEL"),
    SMART_CAMPAIGN_STRATEGY_ID("STRATEGY_ID"),
    SMART_CAMPAIGN_TRACKING_PARAMS("TRACKING_PARAMS"),

    TEXT_CAMPAIGN_COUNTER_IDS("COUNTER_IDS"),
    TEXT_CAMPAIGN_RELEVANT_KEYWORDS("RELEVANT_KEYWORDS"),
    TEXT_CAMPAIGN_SETTINGS("SETTINGS"),
    TEXT_CAMPAIGN_BIDDING_STRATEGY("BIDDING_STRATEGY"),
    TEXT_CAMPAIGN_PRIORITY_GOALS("PRIORITY_GOALS"),
    TEXT_CAMPAIGN_ATTRIBUTION_MODEL("ATTRIBUTION_MODEL"),
    TEXT_CAMPAIGN_STRATEGY_ID("STRATEGY_ID"),
    TEXT_CAMPAIGN_TRACKING_PARAMS("TRACKING_PARAMS");

    val apiValue: Enum<*>? =
        when {
            name.startsWith("CPM_BANNER_CAMPAIGN") ->
                enumValueOf<CpmBannerCampaignFieldEnum>(fieldName)
            name.startsWith("DYNAMIC_TEXT_CAMPAIGN") ->
                enumValueOf<DynamicTextCampaignFieldEnum>(fieldName)
            name.startsWith("MOBILE_APP_CAMPAIGN") ->
                enumValueOf<MobileAppCampaignFieldEnum>(fieldName)
            name.startsWith("SMART_CAMPAIGN") ->
                enumValueOf<SmartCampaignFieldEnum>(fieldName)
            name.startsWith("TEXT_CAMPAIGN") ->
                enumValueOf<TextCampaignFieldEnum>(fieldName)
            else -> enumValues<CampaignFieldEnum>()
                .find { it.name == fieldName }
        }

    val extApiValue: Enum<*> =
        when {
            name.startsWith("CONTENT_PROMOTION_CAMPAIGN") ->
                enumValueOf<com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignFieldEnum>(fieldName)
            name.startsWith("CPM_BANNER_CAMPAIGN") ->
                enumValueOf<com.yandex.direct.api.v5.campaignsext.CpmBannerCampaignFieldEnum>(fieldName)
            name.startsWith("DYNAMIC_TEXT_CAMPAIGN") ->
                enumValueOf<com.yandex.direct.api.v5.campaignsext.DynamicTextCampaignFieldEnum>(fieldName)
            name.startsWith("MOBILE_APP_CAMPAIGN") ->
                enumValueOf<com.yandex.direct.api.v5.campaignsext.MobileAppCampaignFieldEnum>(fieldName)
            name.startsWith("SMART_CAMPAIGN") ->
                enumValueOf<com.yandex.direct.api.v5.campaignsext.SmartCampaignFieldEnum>(fieldName)
            name.startsWith("TEXT_CAMPAIGN") ->
                enumValueOf<com.yandex.direct.api.v5.campaignsext.TextCampaignFieldEnum>(fieldName)
            else -> enumValueOf<com.yandex.direct.api.v5.campaignsext.CampaignFieldEnum>(fieldName)
        }
}

private val conversionMap: Map<Enum<*>?, CampaignAnyFieldEnum> =
    enumValues<CampaignAnyFieldEnum>()
        .associateBy { it.apiValue }
        .withDefault { x ->
            error("CampaignAnyFieldEnum doesn't have an entry for $x")
        }

fun CampaignFieldEnum.toAnyFieldEnum(): CampaignAnyFieldEnum =
    conversionMap.getValue(this)

fun CpmBannerCampaignFieldEnum.toAnyFieldEnum(): CampaignAnyFieldEnum =
    conversionMap.getValue(this)

fun DynamicTextCampaignFieldEnum.toAnyFieldEnum(): CampaignAnyFieldEnum =
    conversionMap.getValue(this)

fun MobileAppCampaignFieldEnum.toAnyFieldEnum(): CampaignAnyFieldEnum =
    conversionMap.getValue(this)

fun SmartCampaignFieldEnum.toAnyFieldEnum(): CampaignAnyFieldEnum =
    conversionMap.getValue(this)

fun TextCampaignFieldEnum.toAnyFieldEnum(): CampaignAnyFieldEnum =
    conversionMap.getValue(this)

private val extConversionMap: Map<Enum<*>, CampaignAnyFieldEnum> =
    enumValues<CampaignAnyFieldEnum>()
        .associateBy { it.extApiValue }
        .withDefault { x ->
            error("CampaignAnyFieldEnum doesn't have an entry for $x")
        }

fun com.yandex.direct.api.v5.campaignsext.CampaignFieldEnum.toAnyFieldEnum(): CampaignAnyFieldEnum =
    extConversionMap.getValue(this)

fun com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignFieldEnum.toAnyFieldEnum(): CampaignAnyFieldEnum =
    extConversionMap.getValue(this)

fun com.yandex.direct.api.v5.campaignsext.CpmBannerCampaignFieldEnum.toAnyFieldEnum(): CampaignAnyFieldEnum =
    extConversionMap.getValue(this)

fun com.yandex.direct.api.v5.campaignsext.DynamicTextCampaignFieldEnum.toAnyFieldEnum(): CampaignAnyFieldEnum =
    extConversionMap.getValue(this)

fun com.yandex.direct.api.v5.campaignsext.MobileAppCampaignFieldEnum.toAnyFieldEnum(): CampaignAnyFieldEnum =
    extConversionMap.getValue(this)

fun com.yandex.direct.api.v5.campaignsext.SmartCampaignFieldEnum.toAnyFieldEnum(): CampaignAnyFieldEnum =
    extConversionMap.getValue(this)

fun com.yandex.direct.api.v5.campaignsext.TextCampaignFieldEnum.toAnyFieldEnum(): CampaignAnyFieldEnum =
    extConversionMap.getValue(this)
