package ru.yandex.direct.api.v5.entity.campaigns.container

import ru.yandex.direct.core.entity.campaign.aggrstatus.AggregatedStatusWallet
import ru.yandex.direct.core.entity.campaign.model.CampaignWithAdvancedGeoTargeting
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign
import ru.yandex.direct.core.entity.campaign.model.WalletCampaign
import ru.yandex.direct.core.entity.campoperationqueue.model.CampQueueOperationName
import ru.yandex.direct.core.entity.timetarget.model.GeoTimezone
import java.math.BigDecimal

/**
 * Структура для хранения данных о кампании, используемая методом API5 campaigns.get.
 *
 * Содержит в себе модель кампании и остальные поля, нужные API, но которых нет в модели.
 * Большая часть данных загружается лениво (при первом обращении к полю)
 */
class GetCampaignsContainer(
    val campaign: CommonCampaign,
    val requestedFields: Set<CampaignAnyFieldEnum>,
    val clientUid: Long,
    private val ndsRatioSupplier: () -> BigDecimal,
    private val sumForTransferSupplier: () -> BigDecimal?,
    private val managerFioSupplier: () -> String?,
    private val agencyNameSupplier: () -> String?,
    private val timezoneSupplier: () -> GeoTimezone,
    private val aggregatedStatusWalletSupplier: () -> AggregatedStatusWallet?,
    private val walletSupplier: () -> WalletCampaign?,
    private val queueOperationsSupplier: () -> Set<CampQueueOperationName>,
    private val hasBannersSupplier: () -> Boolean,
    private val hasActiveBannersSupplier: () -> Boolean,
    private val advancedGeoTargetingSupplier: () -> Boolean,
) {
    val ndsRatio: BigDecimal get() = ndsRatioSupplier()
    val sumForTransfer: BigDecimal? get() = sumForTransferSupplier()
    val managerFio: String? get() = managerFioSupplier()
    val agencyName: String? get() = agencyNameSupplier()
    val geoTimezone: GeoTimezone get() = timezoneSupplier()
    val aggregatedStatusWallet: AggregatedStatusWallet? get() = aggregatedStatusWalletSupplier()
    val wallet: WalletCampaign? get() = walletSupplier()
    val queueOperations: Set<CampQueueOperationName> get() = queueOperationsSupplier()
    val hasBanners: Boolean get() = hasBannersSupplier()
    val hasActiveBanners: Boolean get() = hasActiveBannersSupplier()
    val advancedGeoTargeting: Boolean get() = advancedGeoTargetingSupplier()
}
