package ru.yandex.direct.api.v5.entity.campaigns.container

import com.yandex.direct.api.v5.campaigns.CampaignUpdateItem
import ru.yandex.direct.api.v5.validation.DefectType
import ru.yandex.direct.core.entity.campaign.model.BaseCampaign
import ru.yandex.direct.model.ModelChanges

/**
 * Связка итема внешнего запроса и соответствующего ему итема внутреннего запроса.
 * Сделано по аналогии с [ru.yandex.direct.api.v5.entity.ads.AdsUpdateRequestItem] и
 * [ru.yandex.direct.api.v5.entity.campaigns.validation.CampaignsApiValidationSignals.CampaignWrapper]
 *
 * В Ads.Update для валидации запроса в ядро нужно проверять запрос в API, может быть
 * и в API кампаний будет так же
 *
 * Также сюда добавлены поля из
 * [ru.yandex.direct.api.v5.entity.campaigns.validation.CampaignsApiValidationSignals.CampaignWrapper]
 */
data class UpdateCampaignsContainer<out C : BaseCampaign>(
    val externalItem: CampaignUpdateItem,
    val convertedItem: UpdateCampaignsConvertedRequest<C>? = null,
    val errors: List<DefectType> = emptyList(),
    val warnings: List<DefectType> = emptyList(),
)

/**
 * Аналог [ru.yandex.direct.api.v5.entity.campaigns.validation.CampaignsApiValidationSignals.CampaignWrapper]
 * для операции campaigns.update
 */
data class UpdateCampaignsConvertedRequest<out C : BaseCampaign>(
    val modelChanges: ModelChanges<out C>,
    val requireServicing: Boolean? = null,
)
