package ru.yandex.direct.api.v5.entity.campaigns.converter

import com.yandex.direct.api.v5.campaigns.MobileAppCampaignNetworkStrategy
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignNetworkStrategyAdd
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignNetworkStrategyTypeEnum
import com.yandex.direct.api.v5.campaigns.SmartCampaignNetworkStrategy
import com.yandex.direct.api.v5.campaigns.SmartCampaignNetworkStrategyAdd
import com.yandex.direct.api.v5.campaigns.SmartCampaignNetworkStrategyTypeEnum
import com.yandex.direct.api.v5.campaigns.TextCampaignNetworkStrategy
import com.yandex.direct.api.v5.campaigns.TextCampaignNetworkStrategyAdd
import com.yandex.direct.api.v5.campaigns.TextCampaignNetworkStrategyTypeEnum
import org.springframework.beans.BeanUtils
import org.springframework.beans.BeanWrapper
import org.springframework.beans.BeanWrapperImpl
import ru.yandex.direct.core.entity.campaign.model.CampaignsPlatform

fun CampaignsPlatform?.isSearch() = this == CampaignsPlatform.SEARCH || this == CampaignsPlatform.BOTH

fun CampaignsPlatform?.isNetwork() = this == CampaignsPlatform.CONTEXT || this == CampaignsPlatform.BOTH

fun CampaignsPlatform?.isBoth() = this == CampaignsPlatform.BOTH

fun copyPropertiesExceptNull(source: Any?, dest: Any) {
    if (source != null) {
        BeanUtils.copyProperties(source, dest, *getNullPropertyNames(source))
    }
}

fun getNullPropertyNames(source: Any): Array<String> {
    val beanWrapper: BeanWrapper = BeanWrapperImpl(source)
    val descriptors = beanWrapper.propertyDescriptors
    val emptyNames = mutableSetOf<String>()
    for (descriptor in descriptors) {
        val sourceValue = beanWrapper.getPropertyValue(descriptor.name)
        if (sourceValue == null) emptyNames.add(descriptor.name)
    }
    return emptyNames.toTypedArray()
}

fun MobileAppCampaignNetworkStrategy.toContextLimit(): Int? =
    takeIf { it.biddingStrategyType == MobileAppCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT }
        ?.networkDefault
        ?.limitPercent

fun MobileAppCampaignNetworkStrategyAdd.toContextLimit(): Int? =
    takeIf { it.biddingStrategyType == MobileAppCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT }
        ?.networkDefault
        ?.limitPercent

fun SmartCampaignNetworkStrategy.toContextLimit(): Int? =
    takeIf { it.biddingStrategyType == SmartCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT }
        ?.networkDefault
        ?.limitPercent

fun SmartCampaignNetworkStrategyAdd.toContextLimit(): Int? =
    takeIf { it.biddingStrategyType == SmartCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT }
        ?.networkDefault
        ?.limitPercent

fun TextCampaignNetworkStrategy.toContextLimit(): Int? =
    takeIf { it.biddingStrategyType == TextCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT }
        ?.networkDefault
        ?.limitPercent

fun TextCampaignNetworkStrategyAdd.toContextLimit(): Int? =
    takeIf { it.biddingStrategyType == TextCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT }
        ?.networkDefault
        ?.limitPercent