package ru.yandex.direct.api.v5.entity.campaigns.converter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.campaigns.CampaignAddItem;
import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignAddItem;
import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignSetting;
import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignSettingsEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import one.util.streamex.StreamEx;

import ru.yandex.direct.api.v5.entity.campaigns.validation.CampaignsApiValidationSignals;
import ru.yandex.direct.core.entity.campaign.model.CampaignSource;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.model.CpmBannerCampaign;
import ru.yandex.direct.core.entity.timetarget.model.GeoTimezone;

import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.extractCheckPositionIntervalEvent;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.extractDayBudget;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.extractDayBudgetShowMode;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.extractDisabledDomains;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.extractDisabledIps;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.extractDisabledSsp;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.extractEmail;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.extractEnableCheckPositionEvent;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.extractImpressionRateCount;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.extractImpressionRateIntervalDays;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.extractSendAccountNews;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.extractSmsFlags;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.extractSmsTimeInterval;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.extractTimeTarget;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.extractWarningBalance;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.getEshowsSettings;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.toDate;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.CpmBannerCampaignStrategyConverter.toCampaignStrategy;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.DEFAULT_ADD_METRIKA_TAG_TO_URL;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.DEFAULT_ADD_OPENSTAT_TAG_TO_URL;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.DEFAULT_ADD_TO_FAVORITES;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.DEFAULT_HAS_EXTENDED_GEO_TARGETING;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.DEFAULT_HAS_SITE_MONITORING;
import static ru.yandex.direct.utils.CommonUtils.nvl;

@ParametersAreNonnullByDefault
public class CpmBannerCampaignAddItemConverter {

    private static final Map<CpmBannerCampaignSettingsEnum, Boolean> DEFAULT_SETTINGS = Map.of(
            CpmBannerCampaignSettingsEnum.ADD_OPENSTAT_TAG, DEFAULT_ADD_OPENSTAT_TAG_TO_URL,
            CpmBannerCampaignSettingsEnum.ADD_METRICA_TAG, DEFAULT_ADD_METRIKA_TAG_TO_URL,
            CpmBannerCampaignSettingsEnum.ADD_TO_FAVORITES, DEFAULT_ADD_TO_FAVORITES,
            CpmBannerCampaignSettingsEnum.ENABLE_AREA_OF_INTEREST_TARGETING, DEFAULT_HAS_EXTENDED_GEO_TARGETING,
            CpmBannerCampaignSettingsEnum.ENABLE_SITE_MONITORING, DEFAULT_HAS_SITE_MONITORING
    );

    public static CampaignsApiValidationSignals.CampaignWrapper convertCpmBannerCampaign(
            CampaignAddItem item,
            Long chiefUid,
            String userEmail,
            Map<String, GeoTimezone> timeZones,
            CampaignSource campaignSource,
            Set<String> knownSsps,
            boolean advancedGeoTargeting) {
        CpmBannerCampaignAddItem cpmBannerCampaignItem = item.getCpmBannerCampaign();

        Map<CpmBannerCampaignSettingsEnum, Boolean> settings = convertCpmBannerCampaignSettings(
                cpmBannerCampaignItem.getSettings(),
                advancedGeoTargeting
        );
        Set<Long> favoriteForUids = settings.get(CpmBannerCampaignSettingsEnum.ADD_TO_FAVORITES) ?
                Set.of(chiefUid) : null;

        var campaign = new CpmBannerCampaign()
                .withSource(campaignSource)
                .withType(CampaignType.CPM_BANNER)
                .withName(item.getName())
                .withStrategy(toCampaignStrategy(cpmBannerCampaignItem.getBiddingStrategy()))
                .withHasAddOpenstatTagToUrl(settings.get(CpmBannerCampaignSettingsEnum.ADD_OPENSTAT_TAG))
                .withHasAddMetrikaTagToUrl(settings.get(CpmBannerCampaignSettingsEnum.ADD_METRICA_TAG))
                .withHasExtendedGeoTargeting(settings.get(
                        CpmBannerCampaignSettingsEnum.ENABLE_AREA_OF_INTEREST_TARGETING))
                .withUseCurrentRegion(settings.get(CpmBannerCampaignSettingsEnum.ENABLE_CURRENT_AREA_TARGETING))
                .withUseRegularRegion(settings.get(CpmBannerCampaignSettingsEnum.ENABLE_REGULAR_AREA_TARGETING))
                .withHasSiteMonitoring(settings.get(CpmBannerCampaignSettingsEnum.ENABLE_SITE_MONITORING))
                .withFavoriteForUids(favoriteForUids)
                .withStartDate(toDate(item.getStartDate()))
                .withEndDate(toDate(item.getEndDate()))
                .withSmsTime(extractSmsTimeInterval(item))
                .withSmsFlags(extractSmsFlags(item))
                .withDayBudget(extractDayBudget(item))
                .withDayBudgetShowMode(extractDayBudgetShowMode(item))
                .withTimeZoneId(item.getTimeZone() == null ? 0 : timeZones.get(item.getTimeZone()).getTimezoneId())
                .withTimeTarget(extractTimeTarget(item))
                .withMetrikaCounters(CampaignsAddRequestConverter.toMetrikaCounters(
                        cpmBannerCampaignItem.getCounterIds()))
                .withFio(item.getClientInfo())
                .withEmail(nvl(extractEmail(item.getNotification()), userEmail))
                .withWarningBalance(extractWarningBalance(item.getNotification()))
                .withCheckPositionIntervalEvent(extractCheckPositionIntervalEvent(item.getNotification()))
                .withEnableSendAccountNews(extractSendAccountNews(item))
                .withEnableCheckPositionEvent(extractEnableCheckPositionEvent(item.getNotification()))
                .withDisabledIps(extractDisabledIps(item))
                .withDisabledSsp(extractDisabledSsp(item, knownSsps))
                .withDisabledDomains(extractDisabledDomains(item, knownSsps))
                .withImpressionRateCount(extractImpressionRateCount(cpmBannerCampaignItem))
                .withImpressionRateIntervalDays(extractImpressionRateIntervalDays(cpmBannerCampaignItem))
                .withEshowsSettings(getEshowsSettings(cpmBannerCampaignItem.getVideoTarget()));

        return new CampaignsApiValidationSignals.CampaignWrapper()
                .withRealCampaign(campaign)
                .withRequireServicing(settings.get(CpmBannerCampaignSettingsEnum.REQUIRE_SERVICING));
    }

    private static Map<CpmBannerCampaignSettingsEnum, Boolean> convertCpmBannerCampaignSettings(
            List<CpmBannerCampaignSetting> settings,
            boolean advancedGeoTargeting) {
        Map<CpmBannerCampaignSettingsEnum, Boolean> valueByOption = new HashMap<>();
        for (CpmBannerCampaignSetting s : settings) {
            valueByOption.put(s.getOption(), s.getValue() == YesNoEnum.YES);
        }

        if (advancedGeoTargeting) {
            if (!valueByOption.containsKey(CpmBannerCampaignSettingsEnum.ENABLE_CURRENT_AREA_TARGETING)) {
                valueByOption.put(CpmBannerCampaignSettingsEnum.ENABLE_CURRENT_AREA_TARGETING, true);
            }
            if (!valueByOption.containsKey(CpmBannerCampaignSettingsEnum.ENABLE_REGULAR_AREA_TARGETING)) {
                valueByOption.put(CpmBannerCampaignSettingsEnum.ENABLE_REGULAR_AREA_TARGETING, true);
            }
        }
        return StreamEx.of(CpmBannerCampaignSettingsEnum.values())
                .mapToEntry(option -> valueByOption.getOrDefault(option, DEFAULT_SETTINGS.get(option)))
                .nonNullValues()
                .toMap();
    }

}
