package ru.yandex.direct.api.v5.entity.campaigns.converter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.campaigns.CampaignAddItem;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignAddItem;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSetting;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSettingsEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import one.util.streamex.StreamEx;

import ru.yandex.direct.api.v5.entity.campaigns.validation.CampaignsApiValidationSignals;
import ru.yandex.direct.core.entity.campaign.model.CampaignSource;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.model.DbStrategy;
import ru.yandex.direct.core.entity.campaign.model.MobileContentCampaign;
import ru.yandex.direct.core.entity.timetarget.model.GeoTimezone;

import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.extractCheckPositionIntervalEvent;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.extractDayBudget;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.extractDayBudgetShowMode;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.extractDisabledDomains;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.extractDisabledIps;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.extractDisabledSsp;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.extractEmail;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.extractEnableCheckPositionEvent;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.extractMinusKeywords;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.extractSendAccountNews;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.extractSmsFlags;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.extractSmsTimeInterval;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.extractTimeTarget;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.extractWarningBalance;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.getEnableCpcHold;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.CampaignDataConverterKt.toDate;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.MobileAppCampaignStrategyConverter.toCampaignStrategy;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.DEFAULT_ADD_TO_FAVORITES;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.DEFAULT_ENABLE_CPC_HOLD;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.DEFAULT_HAS_EXTENDED_GEO_TARGETING;
import static ru.yandex.direct.utils.CommonUtils.nvl;

@ParametersAreNonnullByDefault
public class MobileAppCampaignAddItemConverter {

    // CAMPAIGN_EXACT_PHRASE_MATCHING_ENABLED (IS_ORDER_PHRASE_LENGTH_PRECEDENCE_ENABLED в модели) - должно быть null,
    // если у пользователя нет фичи, смотри CampaignWithOrderPhraseLengthPrecedenceForbiddenValidator, поэтому  дефолт
    // не проставляем, чтобы не перезатиреть null
    // ENABLE_AUTOFOCUS, ENABLE_BEHAVIORAL_TARGETING - deprecated
    private static final Map<MobileAppCampaignSettingsEnum, Boolean> DEFAULT_SETTINGS = Map.of(

            MobileAppCampaignSettingsEnum.ADD_TO_FAVORITES, DEFAULT_ADD_TO_FAVORITES,
            MobileAppCampaignSettingsEnum.ENABLE_AREA_OF_INTEREST_TARGETING, DEFAULT_HAS_EXTENDED_GEO_TARGETING,
            MobileAppCampaignSettingsEnum.MAINTAIN_NETWORK_CPC, DEFAULT_ENABLE_CPC_HOLD
    );

    public static CampaignsApiValidationSignals.CampaignWrapper convertMobileAppCampaign(
            CampaignAddItem item,
            Long chiefUid,
            String userEmail,
            Map<String, GeoTimezone> timeZones,
            CampaignSource campaignSource,
            Set<String> knownSsps,
            boolean advancedGeoTargeting) {
        MobileAppCampaignAddItem mobileAppCampaignItem = item.getMobileAppCampaign();

        Map<MobileAppCampaignSettingsEnum, Boolean> settings = convertMobileAppCampaignSettings(
                mobileAppCampaignItem.getSettings(), advancedGeoTargeting);
        Set<Long> favoriteForUids = settings.get(MobileAppCampaignSettingsEnum.ADD_TO_FAVORITES) ?
                Set.of(chiefUid) : null;

        DbStrategy strategy = toCampaignStrategy(mobileAppCampaignItem.getBiddingStrategy());
        var campaign = new MobileContentCampaign()
                .withSource(campaignSource)
                .withType(CampaignType.MOBILE_CONTENT)
                .withName(item.getName())
                .withStrategy(strategy)

                /*
                На самом деле это значение не всегда применится, в ядре есть такой код:
                if (isAutoBudget || isDifferentPlaces) {
                  campaign.setContextLimit(AUTO_CONTEXT_LIMIT);
                }
                Здесь проставляем всегда, потому что знаем, что ядро когда надо - перезатрёт.
                null ядро заменит на 0, покрывается авто-тестом StrategyDefaultBidsManualTest
                */
                .withContextLimit(CampaignConversionUtilsKt.toContextLimit(
                        mobileAppCampaignItem.getBiddingStrategy().getNetwork()))

                .withHasExtendedGeoTargeting(settings.get(
                        MobileAppCampaignSettingsEnum.ENABLE_AREA_OF_INTEREST_TARGETING))
                .withEnableCpcHold(getEnableCpcHold(strategy.isAutoBudget(),
                        settings.get(MobileAppCampaignSettingsEnum.MAINTAIN_NETWORK_CPC)))
                .withIsOrderPhraseLengthPrecedenceEnabled(
                        settings.get(MobileAppCampaignSettingsEnum.CAMPAIGN_EXACT_PHRASE_MATCHING_ENABLED))
                .withUseCurrentRegion(settings.get(MobileAppCampaignSettingsEnum.ENABLE_CURRENT_AREA_TARGETING))
                .withUseRegularRegion(settings.get(MobileAppCampaignSettingsEnum.ENABLE_REGULAR_AREA_TARGETING))
                .withFavoriteForUids(favoriteForUids)
                .withStartDate(toDate(item.getStartDate()))
                .withEndDate(toDate(item.getEndDate()))
                .withEmail(userEmail)
                .withSmsTime(extractSmsTimeInterval(item))
                .withSmsFlags(extractSmsFlags(item))
                .withDayBudget(extractDayBudget(item))
                .withDayBudgetShowMode(extractDayBudgetShowMode(item))
                .withTimeZoneId(item.getTimeZone() == null ? 0 : timeZones.get(item.getTimeZone()).getTimezoneId())
                .withTimeTarget(extractTimeTarget(item))
                .withDeviceTypeTargeting(null)
                .withNetworkTargeting(null)
                .withMobileAppId(0L) // ставим 0, т.к. mobileAppId не передаётся
                .withFio(item.getClientInfo())
                .withMinusKeywords(extractMinusKeywords(item))
                .withEmail(nvl(extractEmail(item.getNotification()), userEmail))
                .withWarningBalance(extractWarningBalance(item.getNotification()))
                .withCheckPositionIntervalEvent(extractCheckPositionIntervalEvent(item.getNotification()))
                .withEnableSendAccountNews(extractSendAccountNews(item))
                .withEnableCheckPositionEvent(extractEnableCheckPositionEvent(item.getNotification()))
                .withDisabledIps(extractDisabledIps(item))
                .withDisabledSsp(extractDisabledSsp(item, knownSsps))
                .withDisabledDomains(extractDisabledDomains(item, knownSsps))
                .withStrategyId(mobileAppCampaignItem.getStrategyId());

        return new CampaignsApiValidationSignals.CampaignWrapper()
                .withRealCampaign(campaign)
                .withRequireServicing(settings.get(MobileAppCampaignSettingsEnum.REQUIRE_SERVICING));
    }

    private static Map<MobileAppCampaignSettingsEnum, Boolean> convertMobileAppCampaignSettings(
            List<MobileAppCampaignSetting> settings, boolean advancedGeoTargeting) {
        Map<MobileAppCampaignSettingsEnum, Boolean> valueByOption = new HashMap<>();
        for (MobileAppCampaignSetting s : settings) {
            valueByOption.put(s.getOption(), s.getValue() == YesNoEnum.YES);
        }
        if (advancedGeoTargeting) {
            if (!valueByOption.containsKey(MobileAppCampaignSettingsEnum.ENABLE_CURRENT_AREA_TARGETING)) {
                valueByOption.put(MobileAppCampaignSettingsEnum.ENABLE_CURRENT_AREA_TARGETING, true);
            }
            if (!valueByOption.containsKey(MobileAppCampaignSettingsEnum.ENABLE_REGULAR_AREA_TARGETING)) {
                valueByOption.put(MobileAppCampaignSettingsEnum.ENABLE_REGULAR_AREA_TARGETING, true);
            }
        }
        return StreamEx.of(MobileAppCampaignSettingsEnum.values())
                .mapToEntry(option -> valueByOption.getOrDefault(option, DEFAULT_SETTINGS.get(option)))
                .nonNullValues()
                .toMap();
    }

}
