package ru.yandex.direct.api.v5.entity.campaigns.converter

import com.yandex.direct.api.v5.campaigns.StrategyAverageCpa
import com.yandex.direct.api.v5.campaigns.StrategyAverageCpaPerCampaign
import com.yandex.direct.api.v5.campaigns.StrategyAverageCpaPerFilter
import com.yandex.direct.api.v5.campaigns.StrategyAverageCpc
import com.yandex.direct.api.v5.campaigns.StrategyAverageCpcPerCampaign
import com.yandex.direct.api.v5.campaigns.StrategyAverageCpcPerFilter
import com.yandex.direct.api.v5.campaigns.StrategyAverageCpi
import com.yandex.direct.api.v5.campaigns.StrategyAverageCrr
import com.yandex.direct.api.v5.campaigns.StrategyAverageRoi
import com.yandex.direct.api.v5.campaigns.StrategyCpAverageCpv
import com.yandex.direct.api.v5.campaigns.StrategyCpDecreasedPriceForRepeatedImpressions
import com.yandex.direct.api.v5.campaigns.StrategyCpMaximumImpressions
import com.yandex.direct.api.v5.campaigns.StrategyMaximumAppInstalls
import com.yandex.direct.api.v5.campaigns.StrategyMaximumClicks
import com.yandex.direct.api.v5.campaigns.StrategyMaximumConversionRate
import com.yandex.direct.api.v5.campaigns.StrategyNetworkDefault
import com.yandex.direct.api.v5.campaigns.StrategyPayForConversion
import com.yandex.direct.api.v5.campaigns.StrategyPayForConversionCrr
import com.yandex.direct.api.v5.campaigns.StrategyPayForConversionPerCampaign
import com.yandex.direct.api.v5.campaigns.StrategyPayForConversionPerFilter
import com.yandex.direct.api.v5.campaigns.StrategyPayForInstall
import com.yandex.direct.api.v5.campaigns.StrategyWbAverageCpv
import com.yandex.direct.api.v5.campaigns.StrategyWbDecreasedPriceForRepeatedImpressions
import com.yandex.direct.api.v5.campaigns.StrategyWbMaximumImpressions
import com.yandex.direct.api.v5.campaigns.StrategyWeeklyClickPackage
import com.yandex.direct.api.v5.general.YesNoEnum
import ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros
import ru.yandex.direct.core.entity.campaign.model.StrategyData
import java.time.LocalDate

/**
 * Конвертеры стратегий internal to external для campaigns (не campaignsext)
 */

fun toStrategyPayForConversion(strategyData: StrategyData) =
    StrategyPayForConversion().apply {
        cpa = convertToMicros(strategyData.avgCpa)
        goalId = strategyData.goalId
        weeklySpendLimit = FACTORY.createStrategyPayForConversionWeeklySpendLimit(
            convertToMicros(strategyData.sum)
        )
    }

fun toStrategyAverageCpa(strategyData: StrategyData) =
    StrategyAverageCpa().apply {
        averageCpa = convertToMicros(strategyData.avgCpa)
        goalId = strategyData.goalId
        weeklySpendLimit = FACTORY.createStrategyAverageCpaWeeklySpendLimit(
            convertToMicros(strategyData.sum)
        )
        bidCeiling = FACTORY.createStrategyAverageCpaBidCeiling(
            convertToMicros(strategyData.bid)
        )
    }

fun toStrategyAverageCpc(strategyData: StrategyData) =
    StrategyAverageCpc().apply {
        averageCpc = convertToMicros(strategyData.avgBid)
        weeklySpendLimit = FACTORY.createStrategyAverageCpcWeeklySpendLimit(
            convertToMicros(strategyData.sum)
        )
    }

fun toStrategyPayForConversionCrr(strategyData: StrategyData) =
    StrategyPayForConversionCrr().apply {
        crr = strategyData.crr?.toInt()
        goalId = strategyData.goalId
        weeklySpendLimit = FACTORY.createStrategyPayForConversionCrrWeeklySpendLimit(
            convertToMicros(strategyData.sum)
        )
    }

fun toStrategyAverageCrr(strategyData: StrategyData) =
    StrategyAverageCrr().apply {
        crr = strategyData.crr?.toInt()
        goalId = strategyData.goalId
        weeklySpendLimit = FACTORY.createStrategyAverageCpaWeeklySpendLimit(
            convertToMicros(strategyData.sum)
        )
    }

fun toStrategyAverageRoi(strategyData: StrategyData) =
    StrategyAverageRoi().apply {
        reserveReturn = strategyData.reserveReturn?.toInt()
        roiCoef = convertToMicros(strategyData.roiCoef)
        goalId = strategyData.goalId
        weeklySpendLimit = FACTORY.createStrategyAverageRoiWeeklySpendLimit(
            convertToMicros(strategyData.sum)
        )
        bidCeiling = FACTORY.createStrategyAverageRoiBidCeiling(
            convertToMicros(strategyData.bid)
        )
        profitability = FACTORY.createStrategyAverageRoiProfitability(
            convertToMicros(strategyData.profitability)
        )
    }

fun toStrategyMaximumClicks(strategyData: StrategyData) =
    StrategyMaximumClicks().apply {
        weeklySpendLimit = convertToMicros(strategyData.sum)
        bidCeiling = FACTORY.createStrategyWeeklyBudgetBaseBidCeiling(
            convertToMicros(strategyData.bid)
        )
    }

fun toStrategyMaximumConversionRate(strategyData: StrategyData) =
    StrategyMaximumConversionRate().apply {
        weeklySpendLimit = convertToMicros(strategyData.sum)
        bidCeiling = FACTORY.createStrategyWeeklyBudgetBaseBidCeiling(
            convertToMicros(strategyData.bid)
        )
        goalId = strategyData.goalId
    }

fun toStrategyWeeklyClickPackage(strategyData: StrategyData) =
    StrategyWeeklyClickPackage().apply {
        clicksPerWeek = strategyData.limitClicks
        averageCpc = FACTORY.createStrategyWeeklyClickPackageAverageCpc(
            convertToMicros(strategyData.avgBid)
        )
        bidCeiling = FACTORY.createStrategyWeeklyClickPackageBidCeiling(
            convertToMicros(strategyData.bid)
        )
    }

fun toStrategyWbDecreasedPriceForRepeatedImpressions(strategyData: StrategyData) =
    StrategyWbDecreasedPriceForRepeatedImpressions().apply {
        averageCpm = convertToMicros(strategyData.avgCpm)
        spendLimit = convertToMicros(strategyData.sum)
    }

fun toStrategyCpDecreasedPriceForRepeatedImpressions(strategyData: StrategyData) =
    StrategyCpDecreasedPriceForRepeatedImpressions().apply {
        startDate = strategyData.start.toExternal()
        endDate = strategyData.finish.toExternal()
        autoContinue = strategyData.autoProlongation.toExternal()
        spendLimit = convertToMicros(strategyData.budget)
        averageCpm = convertToMicros(strategyData.avgCpm)
    }

fun toStrategyWbMaximumImpressions(strategyData: StrategyData) =
    StrategyWbMaximumImpressions().apply {
        averageCpm = convertToMicros(strategyData.avgCpm)
        spendLimit = convertToMicros(strategyData.sum)
    }

fun toStrategyCpMaximumImpressions(strategyData: StrategyData) =
    StrategyCpMaximumImpressions().apply {
        startDate = strategyData.start.toExternal()
        endDate = strategyData.finish.toExternal()
        spendLimit = convertToMicros(strategyData.budget)
        averageCpm = convertToMicros(strategyData.avgCpm)
        autoContinue = strategyData.autoProlongation.toExternal()
    }

fun toStrategyWbAverageCpv(strategyData: StrategyData) =
    StrategyWbAverageCpv().apply {
        spendLimit = convertToMicros(strategyData.sum)
        averageCpv = convertToMicros(strategyData.avgCpv)
    }

fun toStrategyCpAverageCpv(strategyData: StrategyData) =
    StrategyCpAverageCpv().apply {
        startDate = strategyData.start.toExternal()
        endDate = strategyData.finish.toExternal()
        spendLimit = convertToMicros(strategyData.budget)
        averageCpv = convertToMicros(strategyData.avgCpv)
        autoContinue = strategyData.autoProlongation.toExternal()
    }

fun toStrategyAverageCpi(strategyData: StrategyData) =
    StrategyAverageCpi().apply {
        averageCpi = convertToMicros(strategyData.avgCpi)
        weeklySpendLimit = FACTORY.createStrategyAverageCpiWeeklySpendLimit(convertToMicros(strategyData.sum))
        bidCeiling = FACTORY.createStrategyAverageCpiBidCeiling(
            convertToMicros(strategyData.bid)
        )
    }

fun toStrategyMaximumAppInstalls(strategyData: StrategyData) =
    StrategyMaximumAppInstalls().apply {
        weeklySpendLimit = convertToMicros(strategyData.sum)
        bidCeiling = FACTORY.createStrategyWeeklyBudgetBaseBidCeiling(
            convertToMicros(strategyData.bid)
        )
    }

fun toStrategyPayForInstall(strategyData: StrategyData) =
    StrategyPayForInstall().apply {
        averageCpi = convertToMicros(strategyData.avgCpi)
        weeklySpendLimit = FACTORY.createStrategyPayForInstallWeeklySpendLimit(convertToMicros(strategyData.sum))
    }

fun toStrategyAverageCpcPerCampaign(strategyData: StrategyData) =
    StrategyAverageCpcPerCampaign().apply {
        averageCpc = convertToMicros(strategyData.avgBid)
        bidCeiling = FACTORY.createStrategyAverageCpcPerCampaignBidCeiling(convertToMicros(strategyData.bid))
        weeklySpendLimit = FACTORY.createStrategyAverageCpcPerCampaignWeeklySpendLimit(
            convertToMicros(strategyData.sum)
        )

    }

fun toStrategyAverageCpcPerFilter(strategyData: StrategyData) =
    StrategyAverageCpcPerFilter().apply {
        filterAverageCpc = FACTORY.createStrategyAverageCpcPerFilterFilterAverageCpc(
            convertToMicros(strategyData.filterAvgBid)
        )
        bidCeiling = FACTORY.createStrategyAverageCpcPerFilterBidCeiling(convertToMicros(strategyData.bid))
        weeklySpendLimit = FACTORY.createStrategyAverageCpcPerFilterWeeklySpendLimit(
            convertToMicros(strategyData.sum)
        )
    }

fun toStrategyAverageCpaPerCampaign(strategyData: StrategyData) =
    StrategyAverageCpaPerCampaign().apply {
        averageCpa = convertToMicros(strategyData.avgCpa)
        goalId = strategyData.goalId
        bidCeiling = FACTORY.createStrategyAverageCpaPerCampaignBidCeiling(convertToMicros(strategyData.bid))
        weeklySpendLimit = FACTORY.createStrategyAverageCpaPerCampaignWeeklySpendLimit(
            convertToMicros(strategyData.sum)
        )
    }

fun toStrategyAverageCpaPerFilter(strategyData: StrategyData) =
    StrategyAverageCpaPerFilter().apply {
        filterAverageCpa = convertToMicros(strategyData.filterAvgCpa)
        goalId = strategyData.goalId
        bidCeiling = FACTORY.createStrategyAverageCpaPerFilterBidCeiling(convertToMicros(strategyData.bid))
        weeklySpendLimit = FACTORY.createStrategyAverageCpaPerFilterWeeklySpendLimit(
            convertToMicros(strategyData.sum)
        )
    }

fun toStrategyPayForConversionPerCampaign(strategyData: StrategyData) =
    StrategyPayForConversionPerCampaign().apply {
        cpa = convertToMicros(strategyData.avgCpa)
        goalId = strategyData.goalId
        weeklySpendLimit = FACTORY.createStrategyPayForConversionPerCampaignWeeklySpendLimit(
            convertToMicros(strategyData.sum)
        )
    }

fun toStrategyPayForConversionPerFilter(strategyData: StrategyData) =
    StrategyPayForConversionPerFilter().apply {
        cpa = convertToMicros(strategyData.filterAvgCpa)
        goalId = strategyData.goalId
        weeklySpendLimit = FACTORY.createStrategyPayForConversionPerFilterWeeklySpendLimit(
            convertToMicros(strategyData.sum)
        )
    }

fun toStrategyNetworkDefault(contextLimit: Int?): StrategyNetworkDefault? =
    StrategyNetworkDefault().apply {
        limitPercent = contextLimit
    }.takeIf { it.limitPercent != 0 }

private fun Long?.toExternal() = if (this == 1L) YesNoEnum.YES else YesNoEnum.NO

private fun LocalDate?.toExternal(): String? = this?.format(DATETIME_FORMATTER)
