package ru.yandex.direct.api.v5.entity.campaigns.validation

import com.yandex.direct.api.v5.campaigns.CampaignsSelectionCriteria
import com.yandex.direct.api.v5.campaigns.GetRequest
import ru.yandex.direct.api.v5.common.validation.GetRequestGeneralValidator
import ru.yandex.direct.api.v5.validation.DefectType
import ru.yandex.direct.api.v5.validation.DefectTypes.maxIdsInSelection
import ru.yandex.direct.api.v5.validation.constraints.Constraints.maxListSize
import ru.yandex.direct.api.v5.validation.validateObject
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.result.ValidationResult

object CampaignsGetRequestValidator {
    private val GET_IDS_LIMIT = 1000

    fun validateRequest(
        request: GetRequest,
    ): ValidationResult<GetRequest, DefectType> {
        return validateObject(request) {
            item(request.selectionCriteria, "SelectionCriteria")
                .checkBy(::validateSelectionCriteria, When.notNull())

            checkBy(GetRequestGeneralValidator::validateRequestWithDefectTypes)
        }
    }

    private fun validateSelectionCriteria(
        selectionCriteria: CampaignsSelectionCriteria,
    ): ValidationResult<CampaignsSelectionCriteria, DefectType> {
        return validateObject(selectionCriteria) {
            item(selectionCriteria.ids, CampaignsSelectionCriteria.PropInfo.IDS.schemaName.toString())
                .check(maxListSize(GET_IDS_LIMIT), maxIdsInSelection())
        }
    }
}
