package ru.yandex.direct.api.v5.entity.campaigns.validation

import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignNetworkStrategyTypeEnum
import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignSearchStrategyTypeEnum

fun getNetworkStrategyTypesCompatibleWith(
    searchStrategyType: CpmBannerCampaignSearchStrategyTypeEnum
): Set<CpmBannerCampaignNetworkStrategyTypeEnum> {
    return when (searchStrategyType) {
        CpmBannerCampaignSearchStrategyTypeEnum.SERVING_OFF ->
            setOf(
                CpmBannerCampaignNetworkStrategyTypeEnum.MANUAL_CPM,
                CpmBannerCampaignNetworkStrategyTypeEnum.CP_DECREASED_PRICE_FOR_REPEATED_IMPRESSIONS,
                CpmBannerCampaignNetworkStrategyTypeEnum.CP_MAXIMUM_IMPRESSIONS,
                CpmBannerCampaignNetworkStrategyTypeEnum.WB_DECREASED_PRICE_FOR_REPEATED_IMPRESSIONS,
                CpmBannerCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_IMPRESSIONS,
                CpmBannerCampaignNetworkStrategyTypeEnum.WB_AVERAGE_CPV,
                CpmBannerCampaignNetworkStrategyTypeEnum.CP_AVERAGE_CPV
            )
        else ->
            setOf()
    }
}