package ru.yandex.direct.api.v5.entity.campaigns.validation

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignNetworkStrategyTypeEnum
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum

fun getNetworkStrategyTypesCompatibleWith(
    searchStrategyType: DynamicTextCampaignSearchStrategyTypeEnum
): Set<DynamicTextCampaignNetworkStrategyTypeEnum> {
    return when (searchStrategyType) {
        DynamicTextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION,
        DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_CPA,
        DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_CPC,
        DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_ROI,
        DynamicTextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS,
        DynamicTextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CONVERSION_RATE,
        DynamicTextCampaignSearchStrategyTypeEnum.WEEKLY_CLICK_PACKAGE,
        DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_CRR,
        DynamicTextCampaignSearchStrategyTypeEnum.PAY_FOR_CONVERSION,
        DynamicTextCampaignSearchStrategyTypeEnum.PAY_FOR_CONVERSION_CRR ->
            setOf(DynamicTextCampaignNetworkStrategyTypeEnum.SERVING_OFF)
        else ->
            setOf()
    }
}