package ru.yandex.direct.api.v5.entity.campaigns.validation

import com.yandex.direct.api.v5.campaigns.SmartCampaignNetworkStrategyTypeEnum
import com.yandex.direct.api.v5.campaigns.SmartCampaignSearchStrategyTypeEnum
import com.yandex.direct.api.v5.campaigns.SmartCampaignStrategy
import com.yandex.direct.api.v5.campaigns.SmartCampaignStrategyAdd
import ru.yandex.direct.api.v5.entity.campaigns.CampaignDefectTypes
import ru.yandex.direct.api.v5.entity.campaigns.converter.SmartCampaignStrategyConverter.toCampaignStrategy
import ru.yandex.direct.api.v5.entity.campaigns.converter.SmartCampaignUpdateItemConverter.Companion.mergeOldAndNewStrategies
import ru.yandex.direct.api.v5.entity.campaigns.converter.StrategyAddConverter.toCampaignsAutobudget
import ru.yandex.direct.api.v5.entity.campaigns.converter.toContextLimit
import ru.yandex.direct.api.v5.validation.DefectType
import ru.yandex.direct.core.entity.campaign.model.CampaignsAutobudget
import ru.yandex.direct.core.entity.campaign.model.SmartCampaign

fun limitPercentIsConsistentWithStrategy(strategy: SmartCampaignStrategyAdd): DefectType? {
    val isAutobudget = toCampaignsAutobudget(toCampaignStrategy(strategy).strategyName) == CampaignsAutobudget.YES

    val notOk = strategy.network?.toContextLimit() != null
        && isAutobudget
    return if (notOk) CampaignDefectTypes.parameterInconsistentWithStrategy("LimitPercent") else null
}

fun limitPercentIsConsistentWithStrategy(
    newStrategy: SmartCampaignStrategy,
    oldCampaign: SmartCampaign
): DefectType? {
    val fullNewStrategy = mergeOldAndNewStrategies(newStrategy, oldCampaign)
    val notOk = fullNewStrategy.network?.toContextLimit() != null
        && isAutobudget(fullNewStrategy)
    return if (notOk) CampaignDefectTypes.parameterInconsistentWithStrategy("LimitPercent") else null
}

private fun isAutobudget(strategy: SmartCampaignStrategy) =
    toCampaignsAutobudget(toCampaignStrategy(strategy).strategyName) == CampaignsAutobudget.YES

/**
 * Смотри https://yandex.ru/dev/direct/doc/dg/objects/campaign-strategies.html
 */
fun getNetworkStrategyTypesCompatibleWith(
    searchStrategyType: SmartCampaignSearchStrategyTypeEnum
): Set<SmartCampaignNetworkStrategyTypeEnum> {
    return when (searchStrategyType) {
        SmartCampaignSearchStrategyTypeEnum.AVERAGE_CPC_PER_CAMPAIGN,
        SmartCampaignSearchStrategyTypeEnum.AVERAGE_CPC_PER_FILTER,
        SmartCampaignSearchStrategyTypeEnum.AVERAGE_CPA_PER_CAMPAIGN,
        SmartCampaignSearchStrategyTypeEnum.AVERAGE_CPA_PER_FILTER,
        SmartCampaignSearchStrategyTypeEnum.PAY_FOR_CONVERSION_PER_CAMPAIGN,
        SmartCampaignSearchStrategyTypeEnum.PAY_FOR_CONVERSION_PER_FILTER,
        SmartCampaignSearchStrategyTypeEnum.PAY_FOR_CONVERSION_CRR,
        SmartCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CONVERSION_RATE,
        SmartCampaignSearchStrategyTypeEnum.AVERAGE_ROI,
        SmartCampaignSearchStrategyTypeEnum.AVERAGE_CRR ->
            setOf(
                SmartCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT,
                SmartCampaignNetworkStrategyTypeEnum.SERVING_OFF
            )
        SmartCampaignSearchStrategyTypeEnum.SERVING_OFF ->
            setOf(
                SmartCampaignNetworkStrategyTypeEnum.AVERAGE_CPC_PER_CAMPAIGN,
                SmartCampaignNetworkStrategyTypeEnum.AVERAGE_CPC_PER_FILTER,
                SmartCampaignNetworkStrategyTypeEnum.AVERAGE_CPA_PER_CAMPAIGN,
                SmartCampaignNetworkStrategyTypeEnum.AVERAGE_CPA_PER_FILTER,
                SmartCampaignNetworkStrategyTypeEnum.PAY_FOR_CONVERSION_PER_CAMPAIGN,
                SmartCampaignNetworkStrategyTypeEnum.PAY_FOR_CONVERSION_PER_FILTER,
                SmartCampaignNetworkStrategyTypeEnum.PAY_FOR_CONVERSION_CRR,
                SmartCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_CONVERSION_RATE,
                SmartCampaignNetworkStrategyTypeEnum.AVERAGE_ROI,
                SmartCampaignNetworkStrategyTypeEnum.AVERAGE_CRR
            )
        else ->
            setOf()
    }
}
