package ru.yandex.direct.api.v5.entity.campaignsext;

import com.yandex.direct.api.v5.campaignsext.AddRequest;
import com.yandex.direct.api.v5.campaignsext.AddResponse;
import com.yandex.direct.api.v5.campaignsext.ArchiveRequest;
import com.yandex.direct.api.v5.campaignsext.ArchiveResponse;
import com.yandex.direct.api.v5.campaignsext.CampaignsExtPort;
import com.yandex.direct.api.v5.campaignsext.DeleteRequest;
import com.yandex.direct.api.v5.campaignsext.DeleteResponse;
import com.yandex.direct.api.v5.campaignsext.GetRequest;
import com.yandex.direct.api.v5.campaignsext.GetResponse;
import com.yandex.direct.api.v5.campaignsext.ResumeRequest;
import com.yandex.direct.api.v5.campaignsext.ResumeResponse;
import com.yandex.direct.api.v5.campaignsext.SuspendRequest;
import com.yandex.direct.api.v5.campaignsext.SuspendResponse;
import com.yandex.direct.api.v5.campaignsext.UnarchiveRequest;
import com.yandex.direct.api.v5.campaignsext.UnarchiveResponse;
import com.yandex.direct.api.v5.campaignsext.UpdateRequest;
import com.yandex.direct.api.v5.campaignsext.UpdateResponse;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.api.v5.entity.GenericApiService;
import ru.yandex.direct.api.v5.entity.campaigns.delegate.UnarchiveCampaignsExtDelegate;
import ru.yandex.direct.api.v5.entity.campaignsext.delegate.AddCampaignsExtDelegate;
import ru.yandex.direct.api.v5.entity.campaignsext.delegate.ArchiveCampaignsExtDelegate;
import ru.yandex.direct.api.v5.entity.campaignsext.delegate.GetCampaignsExtDelegate;
import ru.yandex.direct.api.v5.entity.campaignsext.delegate.ResumeCampaignsExtDelegate;
import ru.yandex.direct.api.v5.entity.campaignsext.delegate.SuspendCampaignsExtDelegate;
import ru.yandex.direct.api.v5.entity.campaignsext.delegate.UpdateCampaignsExtDelegate;
import ru.yandex.direct.api.v5.ws.annotation.ApiMethod;
import ru.yandex.direct.api.v5.ws.annotation.ApiRequest;
import ru.yandex.direct.api.v5.ws.annotation.ApiResponse;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceEndpoint;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceType;
import ru.yandex.direct.api.v5.ws.annotation.ServiceType;
import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;
import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite;

/**
 * Расширение сервиса campaigns для работы с кампаниями продвижения контента
 * <p>
 * Почти полная калька c {@link ru.yandex.direct.api.v5.entity.campaigns.CampaignsEndpoint}
 */
@ApiServiceEndpoint
@ApiServiceType(type = ServiceType.CLIENT)
public class CampaignsExtEndpoint implements CampaignsExtPort {
    private static final String SERVICE_NAME = "campaignsext";

    private final GenericApiService genericApiService;
    private final GetCampaignsExtDelegate getCampaignsExtDelegate;
    private final AddCampaignsExtDelegate addCampaignsExtDelegate;
    private final ArchiveCampaignsExtDelegate archiveCampaignsExtDelegate;
    private final SuspendCampaignsExtDelegate suspendCampaignsExtDelegate;
    private final ResumeCampaignsExtDelegate resumeCampaignsExtDelegate;
    private final UpdateCampaignsExtDelegate updateCampaignsExtDelegate;
    private final UnarchiveCampaignsExtDelegate unarchiveCampaignsExtDelegate;

    @Autowired
    public CampaignsExtEndpoint(
            GenericApiService genericApiService,
            GetCampaignsExtDelegate getCampaignsExtDelegate,
            AddCampaignsExtDelegate addCampaignsExtDelegate,
            ArchiveCampaignsExtDelegate archiveCampaignsExtDelegate,
            SuspendCampaignsExtDelegate suspendCampaignsExtDelegate,
            ResumeCampaignsExtDelegate resumeCampaignsExtDelegate,
            UpdateCampaignsExtDelegate updateCampaignsExtDelegate,
            UnarchiveCampaignsExtDelegate unarchiveCampaignsExtDelegate
    ) {
        this.genericApiService = genericApiService;
        this.getCampaignsExtDelegate = getCampaignsExtDelegate;
        this.addCampaignsExtDelegate = addCampaignsExtDelegate;
        this.archiveCampaignsExtDelegate = archiveCampaignsExtDelegate;
        this.suspendCampaignsExtDelegate = suspendCampaignsExtDelegate;
        this.resumeCampaignsExtDelegate = resumeCampaignsExtDelegate;
        this.updateCampaignsExtDelegate = updateCampaignsExtDelegate;
        this.unarchiveCampaignsExtDelegate = unarchiveCampaignsExtDelegate;
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "get")
    @ApiResponse
    @Override
    public GetResponse get(@ApiRequest GetRequest parameters) {
        return genericApiService.doAction(getCampaignsExtDelegate, parameters);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "add")
    @ApiResponse
    @Override
    public AddResponse add(@ApiRequest AddRequest parameters) {
        return genericApiService.doAction(addCampaignsExtDelegate, parameters);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "update")
    @ApiResponse
    @Override
    public UpdateResponse update(@ApiRequest UpdateRequest parameters) {
        return genericApiService.doAction(updateCampaignsExtDelegate, parameters);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "delete")
    @ApiResponse
    @Override
    public DeleteResponse delete(@ApiRequest DeleteRequest parameters) {
        throw notImplementedYet();
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "archive")
    @ApiResponse
    @Override
    public ArchiveResponse archive(@ApiRequest ArchiveRequest parameters) {
        return genericApiService.doAction(archiveCampaignsExtDelegate, parameters);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "unarchive")
    @ApiResponse
    @Override
    public UnarchiveResponse unarchive(@ApiRequest UnarchiveRequest parameters) {
        return genericApiService.doAction(unarchiveCampaignsExtDelegate, parameters);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "suspend")
    @ApiResponse
    @Override
    public SuspendResponse suspend(@ApiRequest SuspendRequest parameters) {
        return genericApiService.doAction(suspendCampaignsExtDelegate, parameters);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "resume")
    @ApiResponse
    @Override
    public ResumeResponse resume(@ApiRequest ResumeRequest parameters) {
        return genericApiService.doAction(resumeCampaignsExtDelegate, parameters);
    }

    private static RuntimeException notImplementedYet() {
        return new UnsupportedOperationException("Not implemented yet.");
    }
}
