package ru.yandex.direct.api.v5.entity.campaignsext.converter

import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignSettingGet
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignSettingsGetEnum
import ru.yandex.direct.api.v5.common.toYesNoEnum
import ru.yandex.direct.core.entity.campaign.model.ContentPromotionCampaign

fun createContentPromotionCampaignSettings(
    campaign: ContentPromotionCampaign,
    clientUid: Long,
): List<ContentPromotionCampaignSettingGet> = listOf(
    ContentPromotionCampaignSettingsGetEnum.ADD_TO_FAVORITES
        .enabledIf(clientUid in campaign.favoriteForUids.orEmpty()),
    ContentPromotionCampaignSettingsGetEnum.DAILY_BUDGET_ALLOWED
        .enabledIf(true), // всегда включена
    ContentPromotionCampaignSettingsGetEnum.ENABLE_AREA_OF_INTEREST_TARGETING
        .enabledIf(campaign.hasExtendedGeoTargeting),
    ContentPromotionCampaignSettingsGetEnum.REQUIRE_SERVICING
        .enabledIf(campaign.isServiceRequested == true || (campaign.managerUid ?: 0) > 0),
    ContentPromotionCampaignSettingsGetEnum.SHARED_ACCOUNT_ENABLED
        .enabledIf((campaign.walletId ?: 0L) != 0L)
)

private fun ContentPromotionCampaignSettingsGetEnum.enabledIf(condition: Boolean?): ContentPromotionCampaignSettingGet =
    ContentPromotionCampaignSettingGet()
        .withOption(this)
        .withValue((condition ?: false).toYesNoEnum())
