package ru.yandex.direct.api.v5.entity.campaignsext.converter

import com.yandex.direct.api.v5.campaignsext.CampaignAddItem
import com.yandex.direct.api.v5.campaignsext.CampaignBase
import com.yandex.direct.api.v5.campaignsext.CampaignUpdateItem
import com.yandex.direct.api.v5.campaignsext.CpmBannerCampaignAddItem
import com.yandex.direct.api.v5.campaignsext.DynamicTextCampaignAddItem
import com.yandex.direct.api.v5.campaignsext.MobileAppCampaignAddItem
import com.yandex.direct.api.v5.campaignsext.SmartCampaignAddItem
import com.yandex.direct.api.v5.campaignsext.TextCampaignAddItem
import org.springframework.stereotype.Component

/**
 * Конвертация запросов из CampaignsExt в запросы из Campaigns
 */
@Component
class CampaignExtToCampaignConverter {
    fun convertAddItem(campExtItem: SmartCampaignAddItem): com.yandex.direct.api.v5.campaigns.SmartCampaignAddItem =
        campExtItem.convertBean()

    fun convertAddItem(campExtItem: CpmBannerCampaignAddItem): com.yandex.direct.api.v5.campaigns.CpmBannerCampaignAddItem =
        campExtItem.convertBean()

    fun convertAddItem(campExtItem: DynamicTextCampaignAddItem): com.yandex.direct.api.v5.campaigns.DynamicTextCampaignAddItem =
        campExtItem.convertBean()

    fun convertAddItem(campExtItem: MobileAppCampaignAddItem): com.yandex.direct.api.v5.campaigns.MobileAppCampaignAddItem =
        campExtItem.convertBean()

    fun convertAddItem(campExtItem: TextCampaignAddItem): com.yandex.direct.api.v5.campaigns.TextCampaignAddItem =
        campExtItem.convertBean()

    /**
     * Копируем всё, кроме ContentPromotion
     * (альтернатива это поставить contentPromotionCampaign = null и потом просто вызвать campExtItem.convertBean())
     */
    fun convertAddItem(campExtItem: CampaignAddItem): com.yandex.direct.api.v5.campaigns.CampaignAddItem =
        com.yandex.direct.api.v5.campaigns.CampaignAddItem().apply {
            copyBaseFieldsTo(from = campExtItem, to = this)
            name = campExtItem.name
            startDate = campExtItem.startDate
            dailyBudget = campExtItem.dailyBudget?.convertBean()
            endDate = campExtItem.endDate
            negativeKeywords = campExtItem.negativeKeywords
            blockedIps = campExtItem.blockedIps
            excludedSites = campExtItem.excludedSites
            textCampaign = campExtItem.textCampaign?.convertBean()
            mobileAppCampaign = campExtItem.mobileAppCampaign?.convertBean()
            dynamicTextCampaign = campExtItem.dynamicTextCampaign?.convertBean()
            cpmBannerCampaign = campExtItem.cpmBannerCampaign?.convertBean()
            smartCampaign = campExtItem.smartCampaign?.convertBean()
            timeTargeting = campExtItem.timeTargeting?.convertBean()
        }

    /**
     * Копируем всё, кроме ContentPromotion
     * (альтернатива это поставить contentPromotionCampaign = null и потом просто вызвать campExtItem.convertBean())
     */
    fun convertUpdateItem(campExtItem: CampaignUpdateItem): com.yandex.direct.api.v5.campaigns.CampaignUpdateItem =
        com.yandex.direct.api.v5.campaigns.CampaignUpdateItem().apply {
            copyBaseFieldsTo(from = campExtItem, to = this)
            id = campExtItem.id
            name = campExtItem.name
            startDate = campExtItem.startDate
            dailyBudget = campExtItem.dailyBudget?.convertBean()
            endDate = campExtItem.endDate
            negativeKeywords = campExtItem.negativeKeywords
            blockedIps = campExtItem.blockedIps
            excludedSites = campExtItem.excludedSites
            textCampaign = campExtItem.textCampaign?.convertBean()
            mobileAppCampaign = campExtItem.mobileAppCampaign?.convertBean()
            dynamicTextCampaign = campExtItem.dynamicTextCampaign?.convertBean()
            cpmBannerCampaign = campExtItem.cpmBannerCampaign?.convertBean()
            smartCampaign = campExtItem.smartCampaign?.convertBean()
            timeTargeting = campExtItem.timeTargeting?.convertBean()
        }

    private fun copyBaseFieldsTo(from: CampaignBase, to: com.yandex.direct.api.v5.campaigns.CampaignBase) {
        to.clientInfo = from.clientInfo
        to.notification = from.notification?.convertBean()
        to.timeZone = from.timeZone
    }
}
