package ru.yandex.direct.api.v5.entity.campaignsext.converter

import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignNetworkStrategy
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignNetworkStrategyTypeEnum
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignSearchStrategy
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignSearchStrategyTypeEnum
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignStrategy
import org.slf4j.LoggerFactory
import ru.yandex.direct.api.v5.entity.campaigns.converter.StrategyConverterConstants.DEFAULT_STRATEGY_NAME
import ru.yandex.direct.api.v5.entity.campaigns.converter.toStrategyAverageCpc
import ru.yandex.direct.api.v5.entity.campaigns.converter.toStrategyMaximumClicks
import ru.yandex.direct.api.v5.entity.campaigns.converter.toStrategyWeeklyClickPackage
import ru.yandex.direct.core.entity.campaign.model.ContentPromotionCampaign
import ru.yandex.direct.core.entity.campaign.model.DbStrategy
import ru.yandex.direct.core.entity.campaign.model.StrategyName
import java.lang.invoke.MethodHandles

private val logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass())

fun createContentPromotionGetStrategy(campaign: ContentPromotionCampaign): ContentPromotionCampaignStrategy =
    toContentPromotionCampaignExternalStrategy(campaign.strategy).apply {
        if (search.biddingStrategyType == null) {
            search.biddingStrategyType = ContentPromotionCampaignSearchStrategyTypeEnum.UNKNOWN
            logger.warn("Campaign ${campaign.id} has unknown strategy ${campaign.strategy}")
        }

        if (network.biddingStrategyType == null) {
            network.biddingStrategyType = ContentPromotionCampaignNetworkStrategyTypeEnum.UNKNOWN
            logger.warn("Campaign ${campaign.id} has unknown strategy ${campaign.strategy}")
        }
    }

fun toContentPromotionCampaignExternalStrategy(internalStrategy: DbStrategy) =
    ContentPromotionCampaignStrategy().apply {
        search = getSearchStrategy(internalStrategy)
        // доступна только на поиске
        network = ContentPromotionCampaignNetworkStrategy().apply {
            biddingStrategyType = ContentPromotionCampaignNetworkStrategyTypeEnum.SERVING_OFF
        }
    }

private fun getSearchStrategy(internalStrategy: DbStrategy): ContentPromotionCampaignSearchStrategy {
    val search = ContentPromotionCampaignSearchStrategy()

    val strategyData = internalStrategy.strategyData
    when (strategyData.name) {
        DEFAULT_STRATEGY_NAME -> {
            search.biddingStrategyType = ContentPromotionCampaignSearchStrategyTypeEnum.HIGHEST_POSITION
        }
        StrategyName.AUTOBUDGET_AVG_CLICK.name.lowercase() -> {
            search.biddingStrategyType = ContentPromotionCampaignSearchStrategyTypeEnum.AVERAGE_CPC
            search.averageCpc = toStrategyAverageCpc(strategyData).convertBean()
        }
        StrategyName.AUTOBUDGET.name.lowercase() -> {
            search.biddingStrategyType = ContentPromotionCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS
            search.wbMaximumClicks = toStrategyMaximumClicks(strategyData).convertBean()
        }
        StrategyName.AUTOBUDGET_WEEK_BUNDLE.name.lowercase() -> {
            search.biddingStrategyType = ContentPromotionCampaignSearchStrategyTypeEnum.WEEKLY_CLICK_PACKAGE
            search.weeklyClickPackage = toStrategyWeeklyClickPackage(strategyData).convertBean()
        }
    }

    return search
}
