package ru.yandex.direct.api.v5.entity.campaignsext.converter

import com.yandex.direct.api.v5.campaignsext.CampaignAddItem
import org.springframework.stereotype.Component
import ru.yandex.direct.api.v5.entity.campaigns.converter.CpmBannerCampaignAddItemConverter.convertCpmBannerCampaign
import ru.yandex.direct.api.v5.entity.campaigns.converter.DynamicTextCampaignAddItemConverter.convertDynamicTextCampaign
import ru.yandex.direct.api.v5.entity.campaigns.converter.MobileAppCampaignAddItemConverter.convertMobileAppCampaign
import ru.yandex.direct.api.v5.entity.campaigns.converter.SmartCampaignAddItemConverter.convertSmartCampaign
import ru.yandex.direct.api.v5.entity.campaigns.converter.TextCampaignAddItemConverter.convertTextCampaign
import ru.yandex.direct.api.v5.entity.campaigns.validation.CampaignsApiValidationSignals.CampaignWrapper
import ru.yandex.direct.core.entity.campaign.model.CampaignSource
import ru.yandex.direct.core.entity.feature.service.FeatureService
import ru.yandex.direct.core.entity.timetarget.model.GeoTimezone
import ru.yandex.direct.feature.FeatureName

@Component
class OtherCampaignsAddItemConverter(
    private val converter: CampaignExtToCampaignConverter,
    private val featureService : FeatureService,
) {
    fun convertCpmBannerCampaign(
        campaignExtItem: CampaignAddItem,
        chiefUid: Long,
        userEmail: String,
        timeZones: Map<String, GeoTimezone>,
        campaignSource: CampaignSource,
        knownSsps: Set<String>,
    ): CampaignWrapper = convertCpmBannerCampaign(
        converter.convertAddItem(campaignExtItem),
        chiefUid,
        userEmail,
        timeZones,
        campaignSource,
        knownSsps,
        featureService.isEnabled(chiefUid, FeatureName.ADVANCED_GEOTARGETING),
    )

    fun convertDynamicTextCampaign(
        campaignExtItem: CampaignAddItem,
        chiefUid: Long,
        userEmail: String,
        timeZones: Map<String, GeoTimezone>,
        campaignSource: CampaignSource,
        knownSsps: Set<String>,
    ): CampaignWrapper = convertDynamicTextCampaign(
        converter.convertAddItem(campaignExtItem),
        chiefUid,
        userEmail,
        timeZones,
        campaignSource,
        knownSsps,
        featureService.isEnabled(chiefUid, FeatureName.ADVANCED_GEOTARGETING),
    )

    fun convertMobileAppCampaign(
        campaignExtItem: CampaignAddItem,
        chiefUid: Long,
        userEmail: String,
        timeZones: Map<String, GeoTimezone>,
        campaignSource: CampaignSource,
        knownSsps: Set<String>,
    ): CampaignWrapper = convertMobileAppCampaign(
        converter.convertAddItem(campaignExtItem),
        chiefUid,
        userEmail,
        timeZones,
        campaignSource,
        knownSsps,
        featureService.isEnabled(chiefUid, FeatureName.ADVANCED_GEOTARGETING),
    )

    fun convertSmartCampaign(
        campaignExtItem: CampaignAddItem,
        chiefUid: Long,
        userEmail: String,
        timeZones: Map<String, GeoTimezone>,
        campaignSource: CampaignSource,
        knownSsps: Set<String>,
    ): CampaignWrapper = convertSmartCampaign(
        converter.convertAddItem(campaignExtItem),
        chiefUid,
        userEmail,
        timeZones,
        campaignSource,
        knownSsps,
        featureService.isEnabled(chiefUid, FeatureName.ADVANCED_GEOTARGETING),
    )

    fun convertTextCampaign(
        campaignExtItem: CampaignAddItem,
        chiefUid: Long,
        userEmail: String,
        timeZones: Map<String, GeoTimezone>,
        campaignSource: CampaignSource,
        knownSsps: Set<String>,
    ): CampaignWrapper = convertTextCampaign(
        converter.convertAddItem(campaignExtItem),
        chiefUid,
        userEmail,
        timeZones,
        campaignSource,
        knownSsps,
        featureService.isEnabled(chiefUid, FeatureName.ADVANCED_GEOTARGETING),
    )
}
