package ru.yandex.direct.api.v5.entity.campaignsext.converter

import com.yandex.direct.api.v5.campaignsext.CampaignUpdateItem
import org.springframework.stereotype.Component
import ru.yandex.direct.api.v5.entity.campaigns.converter.CpmBannerCampaignUpdateItemConverter
import ru.yandex.direct.api.v5.entity.campaigns.converter.DynamicTextCampaignUpdateItemConverter
import ru.yandex.direct.api.v5.entity.campaigns.converter.MobileAppCampaignUpdateItemConverter
import ru.yandex.direct.api.v5.entity.campaigns.converter.SmartCampaignUpdateItemConverter
import ru.yandex.direct.api.v5.entity.campaigns.converter.TextCampaignUpdateItemConverter
import ru.yandex.direct.core.entity.campaign.model.BaseCampaign
import ru.yandex.direct.core.entity.campaign.model.CpmBannerCampaign
import ru.yandex.direct.core.entity.campaign.model.DynamicCampaign
import ru.yandex.direct.core.entity.campaign.model.MobileContentCampaign
import ru.yandex.direct.core.entity.campaign.model.SmartCampaign
import ru.yandex.direct.core.entity.campaign.model.TextCampaign
import ru.yandex.direct.core.entity.timetarget.model.GeoTimezone
import ru.yandex.direct.dbutil.model.UidAndClientId

@Component
class OtherCampaignsUpdateItemConverter(
    private val converter: CampaignExtToCampaignConverter,
    private val cpmBannerCampaignUpdateItemConverter: CpmBannerCampaignUpdateItemConverter,
    private val dynamicTextCampaignUpdateItemConverter: DynamicTextCampaignUpdateItemConverter,
    private val mobileAppCampaignUpdateItemConverter: MobileAppCampaignUpdateItemConverter,
    private val smartCampaignUpdateItemConverter: SmartCampaignUpdateItemConverter,
    private val textCampaignUpdateItemConverter: TextCampaignUpdateItemConverter,
) {

    fun getCpmBannerCampaignConverter(): CampaignExtUpdateItemConverter<CpmBannerCampaign> =
        CampaignExtUpdateItemConverter {
                item: CampaignUpdateItem,
                uidAndClientId: UidAndClientId,
                timeZones: Map<String, GeoTimezone>,
                knownSsps: Set<String>,
                campaignFromDb: BaseCampaign?,
            ->
            cpmBannerCampaignUpdateItemConverter.convert(
                converter.convertUpdateItem(item),
                uidAndClientId,
                timeZones,
                knownSsps,
                campaignFromDb,
            )
        }

    fun getDynamicTextCampaignConverter(): CampaignExtUpdateItemConverter<DynamicCampaign> =
        CampaignExtUpdateItemConverter {
                item: CampaignUpdateItem,
                uidAndClientId: UidAndClientId,
                timeZones: Map<String, GeoTimezone>,
                knownSsps: Set<String>,
                campaignFromDb: BaseCampaign?,
            ->
            dynamicTextCampaignUpdateItemConverter.convert(
                converter.convertUpdateItem(item),
                uidAndClientId,
                timeZones,
                knownSsps,
                campaignFromDb,
            )
        }

    fun getMobileAppCampaignConverter(): CampaignExtUpdateItemConverter<MobileContentCampaign> =
        CampaignExtUpdateItemConverter {
                item: CampaignUpdateItem,
                uidAndClientId: UidAndClientId,
                timeZones: Map<String, GeoTimezone>,
                knownSsps: Set<String>,
                campaignFromDb: BaseCampaign?,
            ->
            mobileAppCampaignUpdateItemConverter.convert(
                converter.convertUpdateItem(item),
                uidAndClientId,
                timeZones,
                knownSsps,
                campaignFromDb,
            )
        }

    fun getSmartCampaignConverter(): CampaignExtUpdateItemConverter<SmartCampaign> =
        CampaignExtUpdateItemConverter {
                item: CampaignUpdateItem,
                uidAndClientId: UidAndClientId,
                timeZones: Map<String, GeoTimezone>,
                knownSsps: Set<String>,
                campaignFromDb: BaseCampaign?,
            ->
            smartCampaignUpdateItemConverter.convert(
                converter.convertUpdateItem(item),
                uidAndClientId,
                timeZones,
                knownSsps,
                campaignFromDb,
            )
        }

    fun getTextCampaignConverter(): CampaignExtUpdateItemConverter<TextCampaign> =
        CampaignExtUpdateItemConverter {
                item: CampaignUpdateItem,
                uidAndClientId: UidAndClientId,
                timeZones: Map<String, GeoTimezone>,
                knownSsps: Set<String>,
                campaignFromDb: BaseCampaign?,
            ->
            textCampaignUpdateItemConverter.convert(
                converter.convertUpdateItem(item),
                uidAndClientId,
                timeZones,
                knownSsps,
                campaignFromDb,
            )
        }

}
