package ru.yandex.direct.api.v5.entity.campaignsext.converter;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.campaignsext.StrategyAverageCpcAdd;
import com.yandex.direct.api.v5.campaignsext.StrategyMaximumClicksAdd;
import com.yandex.direct.api.v5.campaignsext.StrategyWeeklyClickPackageAdd;

import ru.yandex.direct.core.entity.campaign.model.CampOptionsStrategy;
import ru.yandex.direct.core.entity.campaign.model.CampaignsAutobudget;
import ru.yandex.direct.core.entity.campaign.model.StrategyData;
import ru.yandex.direct.core.entity.campaign.model.StrategyName;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToDbPrice;
import static ru.yandex.direct.core.entity.campaign.service.CampaignStrategyConstants.AUTOBUDGET_STRATEGIES;

@ParametersAreNonnullByDefault
public class StrategyAddConverter {

    private static final Long FORMAT_VERSION = 1L;

    private StrategyAddConverter() {
        // no instantiation
    }

    public static CampaignsAutobudget toCampaignsAutobudget(StrategyName strategyName) {
        boolean isAutobudget = AUTOBUDGET_STRATEGIES.contains(strategyName);
        return isAutobudget ? CampaignsAutobudget.YES : CampaignsAutobudget.NO;
    }

    public static StrategyData defaultStrategyData() {
        return new StrategyData()
                .withVersion(FORMAT_VERSION)
                .withName("default");
    }

    @Nullable
    public static CampOptionsStrategy toCampOptionsStrategy(StrategyName strategyName) {
        switch (strategyName) {
            case AUTOBUDGET_AVG_CPC_PER_CAMP:
                return CampOptionsStrategy.AUTOBUDGET_AVG_CPC_PER_CAMP;
            case AUTOBUDGET_AVG_CPC_PER_FILTER:
                return CampOptionsStrategy.AUTOBUDGET_AVG_CPC_PER_FILTER;
            case AUTOBUDGET_AVG_CPA_PER_CAMP:
                return CampOptionsStrategy.AUTOBUDGET_AVG_CPA_PER_CAMP;
            case AUTOBUDGET_AVG_CPA_PER_FILTER:
                return CampOptionsStrategy.AUTOBUDGET_AVG_CPA_PER_FILTER;
            default:
                return null;
        }
    }

    public static StrategyData fromAverageCpc(StrategyAverageCpcAdd settingsStructure) {
        return new StrategyData()
                .withVersion(FORMAT_VERSION)
                .withName(StrategyName.AUTOBUDGET_AVG_CLICK.name().toLowerCase())
                .withAvgBid(convertToDbPrice(settingsStructure.getAverageCpc()))
                .withSum(convertToDbPrice(settingsStructure.getWeeklySpendLimit()));
    }

    public static StrategyData fromWbMaximumClicks(StrategyMaximumClicksAdd settingsStructure) {
        return new StrategyData()
                .withVersion(FORMAT_VERSION)
                .withName(StrategyName.AUTOBUDGET.name().toLowerCase())
                .withSum(convertToDbPrice(settingsStructure.getWeeklySpendLimit()))
                .withBid(convertToDbPrice(settingsStructure.getBidCeiling()));
    }

    public static StrategyData fromWeeklyClickPackage(StrategyWeeklyClickPackageAdd settingsStructure) {
        return new StrategyData()
                .withVersion(FORMAT_VERSION)
                .withName(StrategyName.AUTOBUDGET_WEEK_BUNDLE.name().toLowerCase())
                .withLimitClicks(settingsStructure.getClicksPerWeek())
                .withAvgBid(convertToDbPrice(settingsStructure.getAverageCpc()))
                .withBid(convertToDbPrice(settingsStructure.getBidCeiling()));
    }
}
