package ru.yandex.direct.api.v5.entity.campaignsext.converter;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.campaignsext.StrategyAverageCpc;
import com.yandex.direct.api.v5.campaignsext.StrategyMaximumClicks;
import com.yandex.direct.api.v5.campaignsext.StrategyWeeklyClickPackage;

import ru.yandex.direct.core.entity.campaign.model.StrategyData;
import ru.yandex.direct.core.entity.campaign.model.StrategyName;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToDbPrice;
import static ru.yandex.direct.api.v5.entity.campaigns.converter.StrategyUpdateConverter.convertJaxbElementToDbPrice;

@ParametersAreNonnullByDefault
public class StrategyUpdateConverter {

    private static final Long FORMAT_VERSION = 1L;

    private StrategyUpdateConverter() {
        // no instantiation
    }

    public static StrategyData fromAverageCpc(StrategyAverageCpc settingsStructure) {
        return new StrategyData()
                .withVersion(FORMAT_VERSION)
                .withName(StrategyName.AUTOBUDGET_AVG_CLICK.name().toLowerCase())
                .withAvgBid(convertToDbPrice(settingsStructure.getAverageCpc()))
                .withSum(convertJaxbElementToDbPrice(settingsStructure.getWeeklySpendLimit()));
    }

    public static StrategyData fromWbMaximumClicks(StrategyMaximumClicks settingsStructure) {
        return new StrategyData()
                .withVersion(FORMAT_VERSION)
                .withName(StrategyName.AUTOBUDGET.name().toLowerCase())
                .withSum(convertToDbPrice(settingsStructure.getWeeklySpendLimit()))
                .withBid(convertJaxbElementToDbPrice(settingsStructure.getBidCeiling()));
    }

    public static StrategyData fromWeeklyClickPackage(StrategyWeeklyClickPackage settingsStructure) {
        return new StrategyData()
                .withVersion(FORMAT_VERSION)
                .withName(StrategyName.AUTOBUDGET_WEEK_BUNDLE.name().toLowerCase())
                .withLimitClicks(settingsStructure.getClicksPerWeek())
                .withAvgBid(convertJaxbElementToDbPrice(settingsStructure.getAverageCpc()))
                .withBid(convertJaxbElementToDbPrice(settingsStructure.getBidCeiling()));
    }
}
