package ru.yandex.direct.api.v5.entity.campaignsext.delegate

import com.yandex.direct.api.v5.campaignsext.ArchiveRequest
import com.yandex.direct.api.v5.campaignsext.ArchiveResponse
import org.slf4j.LoggerFactory
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service
import ru.yandex.direct.api.v5.common.ApiPathConverter
import ru.yandex.direct.api.v5.converter.ResultConverter
import ru.yandex.direct.api.v5.entity.OperationOnListDelegate
import ru.yandex.direct.api.v5.entity.campaigns.CampaignsEndpoint.DEFECT_PRESENTATIONS_RESPECTING_PATH
import ru.yandex.direct.api.v5.entity.campaignsext.validation.CampaignsExtArchiveRequestValidator
import ru.yandex.direct.api.v5.result.ApiMassResult
import ru.yandex.direct.api.v5.result.ApiResult
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource
import ru.yandex.direct.api.v5.validation.DefectType
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.core.entity.campaign.service.CampaignService
import ru.yandex.direct.core.entity.feature.service.FeatureService
import ru.yandex.direct.validation.result.ValidationResult

@Service
class ArchiveCampaignsExtDelegate @Autowired constructor(
    auth: ApiAuthenticationSource,
    private val campaignService: CampaignService,
    private val requestValidator: CampaignsExtArchiveRequestValidator,
    private val resultConverter: ResultConverter,
    ppcPropertiesSupport: PpcPropertiesSupport,
    featureService: FeatureService
) : OperationOnListDelegate<ArchiveRequest, ArchiveResponse, Long, Long>(
    ApiPathConverter.forCampaigns(), auth, ppcPropertiesSupport, featureService
) {
    override fun validateRequest(externalRequest: ArchiveRequest): ValidationResult<ArchiveRequest, DefectType> =
        requestValidator.validateExternalRequest(externalRequest)

    override fun convertRequest(externalRequest: ArchiveRequest): List<Long> = externalRequest.selectionCriteria.ids

    override fun validateInternalRequest(internalRequest: List<Long>): ValidationResult<List<Long>, DefectType> =
        requestValidator.validateInternalRequest(internalRequest)

    override fun processList(validItems: List<Long>): ApiMassResult<Long> {
        logger.debug("process request: {}", validItems)
        val result = campaignService.archiveCampaigns(validItems, getOperatorUid(), getClientId())
        return resultConverter.toApiMassResultRespectingPath(result, DEFECT_PRESENTATIONS_RESPECTING_PATH)
    }

    override fun convertResponse(result: ApiResult<List<ApiResult<Long>>>): ArchiveResponse =
        ArchiveResponse().withArchiveResults(resultConverter.toActionResults(result, apiPathConverter))

    private fun getClientId() = auth.chiefSubclient.clientId

    private fun getOperatorUid() = auth.operator.uid

    companion object {
        private val logger = LoggerFactory.getLogger(ArchiveCampaignsExtDelegate::class.java)
    }
}
