package ru.yandex.direct.api.v5.entity.campaigns.delegate

import com.yandex.direct.api.v5.campaignsext.UnarchiveRequest
import com.yandex.direct.api.v5.campaignsext.UnarchiveResponse
import org.slf4j.LoggerFactory
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service
import ru.yandex.direct.api.v5.common.ApiPathConverter
import ru.yandex.direct.api.v5.converter.ResultConverter
import ru.yandex.direct.api.v5.entity.OperationOnListDelegate
import ru.yandex.direct.api.v5.entity.campaigns.CampaignsEndpoint.DEFECT_PRESENTATIONS_RESPECTING_PATH
import ru.yandex.direct.api.v5.entity.campaigns.validation.CampaignsExtUnarchiveRequestValidator
import ru.yandex.direct.api.v5.result.ApiMassResult
import ru.yandex.direct.api.v5.result.ApiResult
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource
import ru.yandex.direct.api.v5.validation.DefectType
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.core.entity.campaign.service.CampaignService
import ru.yandex.direct.core.entity.feature.service.FeatureService
import ru.yandex.direct.validation.result.ValidationResult

@Service
class UnarchiveCampaignsExtDelegate @Autowired constructor(
    auth: ApiAuthenticationSource,
    private val campaignService: CampaignService,
    private val requestValidator: CampaignsExtUnarchiveRequestValidator,
    private val resultConverter: ResultConverter,
    ppcPropertiesSupport: PpcPropertiesSupport,
    featureService: FeatureService
) : OperationOnListDelegate<UnarchiveRequest, UnarchiveResponse, Long, Long>(
    ApiPathConverter.forCampaigns(), auth, ppcPropertiesSupport, featureService
) {
    companion object {
        private val logger = LoggerFactory.getLogger(UnarchiveCampaignsDelegate::class.java)
    }

    override fun validateRequest(externalRequest: UnarchiveRequest): ValidationResult<UnarchiveRequest, DefectType> =
        requestValidator.validateExternalRequest(externalRequest)

    override fun convertRequest(externalRequest: UnarchiveRequest): List<Long> =
        externalRequest.selectionCriteria.ids

    override fun validateInternalRequest(internalRequest: List<Long>): ValidationResult<List<Long>, DefectType> =
        requestValidator.validateInternalRequest(internalRequest)

    override fun processList(validItems: List<Long>): ApiMassResult<Long> {
        logger.debug("process request: {}", validItems)
        val result = campaignService.unarchiveCampaigns(validItems, getOperatorUid(), getUidAndClientId())
        return resultConverter.toApiMassResultRespectingPath(result, DEFECT_PRESENTATIONS_RESPECTING_PATH)
    }

    override fun convertResponse(result: ApiResult<List<ApiResult<Long>>>): UnarchiveResponse =
        UnarchiveResponse().withUnarchiveResults(resultConverter.toActionResults(result, apiPathConverter))

    private fun getUidAndClientId() = auth.chiefSubclient.toUidAndClientId()

    private fun getOperatorUid() = auth.operator.uid
}
