package ru.yandex.direct.api.v5.entity.campaignsext.delegate

import com.yandex.direct.api.v5.campaignsext.UpdateRequest
import com.yandex.direct.api.v5.campaignsext.UpdateResponse
import org.slf4j.LoggerFactory
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service
import ru.yandex.direct.api.v5.common.ApiPathConverter
import ru.yandex.direct.api.v5.converter.ResultConverter
import ru.yandex.direct.api.v5.entity.OperationOnListDelegate
import ru.yandex.direct.api.v5.entity.campaigns.CampaignsEndpoint
import ru.yandex.direct.api.v5.entity.campaignsext.container.UpdateCampaignsExtContainer
import ru.yandex.direct.api.v5.entity.campaignsext.converter.CampaignsExtUpdateRequestConverter
import ru.yandex.direct.api.v5.entity.campaignsext.validation.CampaignsExtUpdateRequestValidator
import ru.yandex.direct.api.v5.result.ApiMassResult
import ru.yandex.direct.api.v5.result.ApiResult
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource
import ru.yandex.direct.api.v5.validation.DefectType
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.core.entity.campaign.service.CampaignOperationService
import ru.yandex.direct.core.entity.campaign.service.CampaignOptions
import ru.yandex.direct.core.entity.feature.service.FeatureService
import ru.yandex.direct.result.MassResult
import ru.yandex.direct.validation.result.ValidationResult

@Service
class UpdateCampaignsExtDelegate @Autowired constructor(
    apiAuthenticationSource: ApiAuthenticationSource,
    ppcPropertiesSupport: PpcPropertiesSupport,
    featureService: FeatureService,
    private val requestValidator: CampaignsExtUpdateRequestValidator,
    private val requestConverter: CampaignsExtUpdateRequestConverter,
    private val campaignOperationService: CampaignOperationService,
    private val resultConverter: ResultConverter,
) : OperationOnListDelegate<UpdateRequest, UpdateResponse, UpdateCampaignsExtContainer<*>, Long>(
    ApiPathConverter.forCampaigns(), apiAuthenticationSource, ppcPropertiesSupport, featureService
) {

    override fun validateRequest(
        externalRequest: UpdateRequest,
    ): ValidationResult<UpdateRequest, DefectType>? {
        logger.debug("validate request {}", externalRequest)
        return requestValidator.validateExternalRequest(externalRequest)
    }

    override fun convertRequest(
        externalRequest: UpdateRequest
    ): List<UpdateCampaignsExtContainer<*>> {
        logger.debug("convert request {}", externalRequest)
        return requestConverter.convertRequest(
            uidAndClientId = auth.chiefSubclient.toUidAndClientId(),
            request = externalRequest,
        )
    }

    override fun validateInternalRequest(
        internalRequest: List<UpdateCampaignsExtContainer<*>>
    ): ValidationResult<List<UpdateCampaignsExtContainer<*>>, DefectType> {
        logger.debug("validate internal request {}", internalRequest)
        return requestValidator.validateInternalRequest(internalRequest)
    }

    override fun processList(
        validItems: List<UpdateCampaignsExtContainer<*>>
    ): ApiMassResult<Long> {
        logger.debug("processList: {}", validItems)
        val uidAndCliendId = auth.chiefSubclient.toUidAndClientId()
        val operatorUid = auth.operator.uid
        val requireServicing = validItems.map { it.convertedItem?.requireServicing }
        val options = CampaignOptions.Builder()
            .withForceCheckPositionIntervalEvent(true)
            .withForceEnableCheckPositionEvent(true)
            .withAllowNullDeviceTypeTargeting(true)
            .withAllowNullNetworkTargeting(true)
            .withAllowZeroMobileAppId(true)
            .withRequireServicing(requireServicing)
            .withLimitFioTo255Chars(true)
            .withValidateFioForForbiddenChars(true)
            .withValidateCampaignNameForForbiddenChars(true)
            .withForceValidateAvgCpmMin(true)
            .withSendAutoServicingMailNotification(true)
            .withValidatePayForConversionExtendedModeEnabled(true)
            .withValidatePayForConversionInAutobudgetAvgCpaPerFilter(true)
            .withCheckDisableAllGoalsOptimizationForDnaFeature(true)
            .withFetchMetrikaCountersForGoals(true)
            .withAllowAllGoalsOptimizationForOldCampaigns(true)
            .withIsCheckStrategyForMeaninfulGoalsGoalId(true)

            .build()

        val result: MassResult<Long> =
            campaignOperationService
                .createRestrictedCampaignUpdateOperation(
                    validItems.map {
                        checkNotNull(it.convertedItem?.modelChanges) {
                            "Expected valid request, but found null"
                        }
                    },
                    operatorUid,
                    uidAndCliendId,
                    options
                )
                .apply()

        return resultConverter.toApiMassResultRespectingPath(
            result,
            CampaignsEndpoint.DEFECT_PRESENTATIONS_RESPECTING_PATH
        )
    }

    override fun convertResponse(result: ApiResult<List<ApiResult<Long>>>?): UpdateResponse {
        return UpdateResponse()
            .withUpdateResults(resultConverter.toActionResults(result, apiPathConverter))
    }

    companion object {
        private val logger = LoggerFactory.getLogger(UpdateCampaignsExtDelegate::class.java)
    }
}
