package ru.yandex.direct.api.v5.entity.campaignsext.validation

import com.yandex.direct.api.v5.campaignsext.CampaignsSelectionCriteria
import com.yandex.direct.api.v5.campaignsext.GetRequest
import ru.yandex.direct.api.v5.common.validation.GetRequestGeneralValidator
import ru.yandex.direct.api.v5.validation.DefectType
import ru.yandex.direct.api.v5.validation.DefectTypes
import ru.yandex.direct.api.v5.validation.constraints.Constraints.maxListSize
import ru.yandex.direct.api.v5.validation.validateObject
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.result.ValidationResult

object CampaignsExtGetRequestValidator {
    private val GET_IDS_LIMIT = 1000

    fun validateRequest(
        request: GetRequest,
    ): ValidationResult<GetRequest, DefectType> {
        return validateObject(request) {
            item(request.selectionCriteria, "SelectionCriteria")
                .checkBy(::validateSelectionCriteria, When.notNull())

            checkBy(GetRequestGeneralValidator::validateRequestWithDefectTypes)
        }
    }

    private fun validateSelectionCriteria(
        selectionCriteria: CampaignsSelectionCriteria,
    ): ValidationResult<CampaignsSelectionCriteria, DefectType> {
        return validateObject(selectionCriteria) {
            item(selectionCriteria.ids, CampaignsSelectionCriteria.PropInfo.IDS.schemaName.toString())
                .check(maxListSize(GET_IDS_LIMIT), DefectTypes.maxIdsInSelection())
        }
    }
}
