package ru.yandex.direct.api.v5.entity.campaignsext.validation

import com.yandex.direct.api.v5.campaignsext.CampaignAddItem
import com.yandex.direct.api.v5.campaignsext.CampaignUpdateItem
import ru.yandex.direct.api.v5.entity.campaigns.CampaignDefectTypes.badParamsFieldNotSupportedInCampaign
import ru.yandex.direct.api.v5.validation.DefectType
import ru.yandex.direct.core.entity.campaign.model.CampaignType

/**
 * Аналог перловой проверки [_validate_excluded_domains_for_camp_types](https://a.yandex-team.ru/arc/trunk/arcadia/direct/perl/api/services/v5/API/Service/Campaigns.pm?rev=r8859677#L1274-1282)
 */
fun contentPromotionCampaignHasNoExcludedSites(item: CampaignAddItem): DefectType? {
    return contentPromotionCampaignHasNoExcludedSites(
        item.contentPromotionCampaign != null,
        item.excludedSites != null)
}

fun contentPromotionCampaignHasNoExcludedSites(
    item: CampaignUpdateItem,
    typeFromDb: CampaignType?): DefectType? {
    return contentPromotionCampaignHasNoExcludedSites(
        typeFromDb == CampaignType.CONTENT_PROMOTION,
        item.excludedSites != null)
}

private fun contentPromotionCampaignHasNoExcludedSites(
    isContentPromotion: Boolean,
    hasExcludedDomains: Boolean
) = if (isContentPromotion && hasExcludedDomains) {
    badParamsFieldNotSupportedInCampaign("ExcludedSites")
} else {
    null
}