package ru.yandex.direct.api.v5.entity.campaignsext.validation

import com.yandex.direct.api.v5.campaignsext.CampaignAddItem
import com.yandex.direct.api.v5.campaignsext.CpmBannerCampaignAddItem
import com.yandex.direct.api.v5.campaignsext.DynamicTextCampaignAddItem
import com.yandex.direct.api.v5.campaignsext.MobileAppCampaignAddItem
import com.yandex.direct.api.v5.campaignsext.SmartCampaignAddItem
import com.yandex.direct.api.v5.campaignsext.TextCampaignAddItem
import org.springframework.stereotype.Component
import ru.yandex.direct.api.v5.entity.campaigns.validation.CpmBannerCampaignAddRequestValidator
import ru.yandex.direct.api.v5.entity.campaigns.validation.DynamicTextCampaignAddRequestValidator
import ru.yandex.direct.api.v5.entity.campaigns.validation.MobileAppCampaignAddRequestValidator
import ru.yandex.direct.api.v5.entity.campaigns.validation.SmartCampaignAddRequestValidator
import ru.yandex.direct.api.v5.entity.campaigns.validation.TextCampaignAddRequestValidator
import ru.yandex.direct.api.v5.entity.campaigns.validation.validateCampaignAddItemCommonDefects
import ru.yandex.direct.api.v5.entity.campaignsext.converter.CampaignExtToCampaignConverter
import ru.yandex.direct.api.v5.validation.DefectType
import ru.yandex.direct.core.entity.timetarget.model.GeoTimezone
import ru.yandex.direct.validation.result.ValidationResult

/**
 * Валидаторы для всех кампаний, кроме ContentPromotion
 */
@Component
class OtherCampaignsAddRequestValidator(
    private val converter: CampaignExtToCampaignConverter,
) {

    fun validateCampaignAddItemNormalDefects(
        campaignsExtItem: CampaignAddItem,
        timeZones: Map<String, GeoTimezone>
    ): ValidationResult<CampaignAddItem, DefectType> =
        toCampaignsExtResult(
            campaignsExtItem,
            validateCampaignAddItemCommonDefects(
                converter.convertAddItem(campaignsExtItem),
                timeZones
            )
        )

    fun validateCpmBannerCampaign(
        campaignsExtItem: CpmBannerCampaignAddItem,
    ): ValidationResult<CpmBannerCampaignAddItem, DefectType?> =
        toCampaignsExtResult(
            campaignsExtItem,
            CpmBannerCampaignAddRequestValidator.validateCpmBannerCampaign(
                converter.convertAddItem(campaignsExtItem)
            )
        )

    fun validateDynamicTextCampaign(
        campaignsExtItem: DynamicTextCampaignAddItem,
    ): ValidationResult<DynamicTextCampaignAddItem, DefectType?> =
        toCampaignsExtResult(
            campaignsExtItem,
            DynamicTextCampaignAddRequestValidator.validateDynamicTextCampaign(
                converter.convertAddItem(campaignsExtItem),
            )
        )

    fun validateMobileAppCampaign(
        campaignsExtItem: MobileAppCampaignAddItem
    ): ValidationResult<MobileAppCampaignAddItem, DefectType?> =
        toCampaignsExtResult(
            campaignsExtItem,
            MobileAppCampaignAddRequestValidator.validateMobileAppCampaign(
                converter.convertAddItem(campaignsExtItem)
            )
        )

    fun validateSmartCampaign(
        campaignsExtItem: SmartCampaignAddItem,
    ): ValidationResult<SmartCampaignAddItem, DefectType?> =
        toCampaignsExtResult(
            campaignsExtItem,
            SmartCampaignAddRequestValidator.validateSmartCampaign(
                converter.convertAddItem(campaignsExtItem),
            )
        )

    fun validateTextCampaign(
        campaignsExtItem: TextCampaignAddItem,
    ): ValidationResult<TextCampaignAddItem, DefectType?> =
        toCampaignsExtResult(
            campaignsExtItem,
            TextCampaignAddRequestValidator.validateTextCampaign(
                converter.convertAddItem(campaignsExtItem),
            )
        )

    private fun <T> toCampaignsExtResult(campaignsExtItem: T, convertedResult: ValidationResult<*, DefectType>) =
        ValidationResult(
            campaignsExtItem,
            convertedResult.errors,
            convertedResult.warnings,
            convertedResult.subResults,
        )
}
