package ru.yandex.direct.api.v5.entity.changes;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.changes.ApiException;
import com.yandex.direct.api.v5.changes.ChangesPort;
import com.yandex.direct.api.v5.changes.CheckCampaignsRequest;
import com.yandex.direct.api.v5.changes.CheckCampaignsResponse;
import com.yandex.direct.api.v5.changes.CheckDictionariesRequest;
import com.yandex.direct.api.v5.changes.CheckDictionariesResponse;
import com.yandex.direct.api.v5.changes.CheckRequest;
import com.yandex.direct.api.v5.changes.CheckResponse;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.api.v5.common.ApiPathConverter;
import ru.yandex.direct.api.v5.entity.GenericApiService;
import ru.yandex.direct.api.v5.entity.changes.delegate.CheckCampaignsDelegate;
import ru.yandex.direct.api.v5.entity.changes.delegate.CheckDelegate;
import ru.yandex.direct.api.v5.entity.changes.delegate.CheckDictionariesDelegate;
import ru.yandex.direct.api.v5.ws.annotation.ApiMethod;
import ru.yandex.direct.api.v5.ws.annotation.ApiRequest;
import ru.yandex.direct.api.v5.ws.annotation.ApiResponse;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceEndpoint;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceType;
import ru.yandex.direct.api.v5.ws.annotation.ServiceType;
import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;
import ru.yandex.direct.validation.result.MappingPathConverter;
import ru.yandex.direct.validation.result.PathConverter;

/**
 * Сервис по получению информации об изменениях.
 *
 * @see <a href=https://yandex.ru/dev/direct/doc/ref-v5/changes/changes-docpage/>Changes API tech docs</a>
 */
@ApiServiceEndpoint
@ApiServiceType(type = ServiceType.CLIENT)
@ParametersAreNonnullByDefault
public class ChangesEndpoint implements ChangesPort {

    private static final String SERVICE_NAME = "changes";

    public static final PathConverter PATH_CONVERTER =
            MappingPathConverter.builder(ChangesEndpoint.class, "capitalize")
                    .add(ApiPathConverter.getCommonDict())
                    .build();

    private final GenericApiService genericApiService;
    private final CheckDictionariesDelegate checkDictionariesDelegate;
    private final CheckCampaignsDelegate checkCampaignsDelegate;
    private final CheckDelegate checkDelegate;

    @Autowired
    public ChangesEndpoint(
            GenericApiService genericApiService,
            CheckDictionariesDelegate checkDictionariesDelegate, CheckCampaignsDelegate checkCampaignsDelegate,
            CheckDelegate checkDelegate) {
        this.genericApiService = genericApiService;
        this.checkDictionariesDelegate = checkDictionariesDelegate;
        this.checkCampaignsDelegate = checkCampaignsDelegate;
        this.checkDelegate = checkDelegate;
    }

    @ApiServiceType(type = ServiceType.ALL)
    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "checkDictionaries")
    @ApiResponse
    @Override
    public CheckDictionariesResponse checkDictionaries(@ApiRequest CheckDictionariesRequest checkDictionariesRequest) throws ApiException {
        return genericApiService.doAction(checkDictionariesDelegate, checkDictionariesRequest);
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "checkCampaigns")
    @ApiResponse
    @Override
    public CheckCampaignsResponse checkCampaigns(@ApiRequest CheckCampaignsRequest checkCampaignsRequest) throws ApiException {
        return genericApiService.doAction(checkCampaignsDelegate, checkCampaignsRequest);
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "check")
    @ApiResponse
    @Override
    public CheckResponse check(@ApiRequest CheckRequest checkRequest) throws ApiException {
        return genericApiService.doAction(checkDelegate, checkRequest);
    }

    private static RuntimeException notImplementedYet() {
        return new UnsupportedOperationException("Not implemented yet.");
    }
}
