package ru.yandex.direct.api.v5.entity.changes.validation;

import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.api.v5.validation.DefectTypeCreators;
import ru.yandex.direct.api.v5.validation.wrapper.DirectApiValidator;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.api.v5.entity.changes.converter.ChangesDateTimeConvertUtil.CHANGES_DATETIME_FORMATTER;
import static ru.yandex.direct.api.v5.validation.constraints.Constraints.notNull;
import static ru.yandex.direct.validation.Predicates.validDateTime;

public class ChangesTimestampValidator implements DirectApiValidator<String> {
    private final String fieldName;
    private final boolean isNullableField;//можно ли передать null в качестве даты

    public ChangesTimestampValidator(String fieldName, boolean isNullableField) {
        this.fieldName = fieldName;
        this.isNullableField = isNullableField;
    }

    @Override
    public ValidationResult<String, DefectType> apply(String s) {
        ItemValidationBuilder<String, DefectType> vb = ItemValidationBuilder.of(s);
        if (!isNullableField) {
            vb.check(notNull());
        }
        vb.check(Constraint.fromPredicate(validDateTime(CHANGES_DATETIME_FORMATTER),
                DefectTypeCreators.invalidRequestParamsInvalidDateFormat(fieldName)));
        return vb.getResult();
    }
}
