package ru.yandex.direct.api.v5.entity.changes.validation;

import com.yandex.direct.api.v5.changes.CheckCampaignsRequest;

import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.api.v5.validation.wrapper.DirectApiValidator;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.result.ValidationResult;

public class CheckCampaignsValidator implements DirectApiValidator<CheckCampaignsRequest> {
    private static final String TIMESTAMP_FIELD_NAME =
            CheckCampaignsRequest.PropInfo.TIMESTAMP.schemaName.getLocalPart();

    @Override
    public ValidationResult<CheckCampaignsRequest, DefectType> apply(CheckCampaignsRequest checkCampaignsRequest) {
        ItemValidationBuilder<CheckCampaignsRequest, DefectType> vb = ItemValidationBuilder.of(checkCampaignsRequest);
        vb.item(checkCampaignsRequest.getTimestamp(), TIMESTAMP_FIELD_NAME)
                .checkBy(new ChangesTimestampValidator(TIMESTAMP_FIELD_NAME, false));
        return vb.getResult();
    }
}
