package ru.yandex.direct.api.v5.entity.changes.validation;

import com.yandex.direct.api.v5.changes.CheckDictionariesRequest;

import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.api.v5.validation.wrapper.DirectApiValidator;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.result.ValidationResult;

public class CheckDictionariesValidator implements DirectApiValidator<CheckDictionariesRequest> {
    private static final String TIMESTAMP_FIELD_NAME =
            CheckDictionariesRequest.PropInfo.TIMESTAMP.schemaName.getLocalPart();

    @Override
    public ValidationResult<CheckDictionariesRequest, DefectType> apply(
            CheckDictionariesRequest checkDictionariesRequest) {
        ItemValidationBuilder<CheckDictionariesRequest, DefectType> vb =
                ItemValidationBuilder.of(checkDictionariesRequest);
        vb.item(checkDictionariesRequest.getTimestamp(), TIMESTAMP_FIELD_NAME)
                .checkBy(new ChangesTimestampValidator(TIMESTAMP_FIELD_NAME, true));
        return vb.getResult();
    }
}
