package ru.yandex.direct.api.v5.entity.clients;


import com.yandex.direct.api.v5.clients.ApiException;
import com.yandex.direct.api.v5.clients.ClientsPort;
import com.yandex.direct.api.v5.clients.GetRequest;
import com.yandex.direct.api.v5.clients.GetResponse;
import com.yandex.direct.api.v5.clients.GetSupportPinRequest;
import com.yandex.direct.api.v5.clients.GetSupportPinResponse;
import com.yandex.direct.api.v5.clients.UpdateRequest;
import com.yandex.direct.api.v5.clients.UpdateResponse;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.api.v5.entity.GenericApiService;
import ru.yandex.direct.api.v5.entity.clients.service.GetClientsDelegate;
import ru.yandex.direct.api.v5.entity.clients.service.GetClientsSupportPinDelegate;
import ru.yandex.direct.api.v5.entity.clients.service.UpdateClientOperation;
import ru.yandex.direct.api.v5.ws.annotation.ApiMethod;
import ru.yandex.direct.api.v5.ws.annotation.ApiRequest;
import ru.yandex.direct.api.v5.ws.annotation.ApiResponse;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceEndpoint;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceType;
import ru.yandex.direct.api.v5.ws.annotation.ServiceType;
import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;
import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite;


/**
 * Soap service
 */
@ApiServiceEndpoint
@ApiServiceType(type = ServiceType.CLIENT)
public class ClientsEndpoint implements ClientsPort {
    private static final String SERVICE_NAME = "clients";

    private final GetClientsDelegate getClientsDelegate;
    private final GetClientsSupportPinDelegate getSupportPinDelegate;
    private final GenericApiService genericApiService;
    private final UpdateClientOperation updateClientOperation;

    @Autowired
    public ClientsEndpoint(
            GetClientsDelegate getClientsDelegate, GetClientsSupportPinDelegate getSupportPinDelegate, GenericApiService genericApiService,
            UpdateClientOperation updateClientOperation) {
        this.getClientsDelegate = getClientsDelegate;
        this.getSupportPinDelegate = getSupportPinDelegate;
        this.genericApiService = genericApiService;
        this.updateClientOperation = updateClientOperation;
    }

    // метод GET может быть нацелен на получение информации и об агентствах и о конечных рекламодателях
    @ApiServiceType(type = ServiceType.AGENCY_AND_CLIENT)
    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "get")
    @ApiResponse
    @Override
    public GetResponse get(@ApiRequest GetRequest getRequest) throws ApiException {
        return genericApiService.doAction(getClientsDelegate, getRequest);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "getSupportPin")
    @ApiResponse
    @Override
    public GetSupportPinResponse getSupportPin(@ApiRequest GetSupportPinRequest getSupportPinRequest) throws ApiException {
        return genericApiService.doAction(getSupportPinDelegate, getSupportPinRequest);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "update")
    @ApiResponse
    @Override
    public UpdateResponse update(@ApiRequest UpdateRequest request) throws ApiException {
        return updateClientOperation.perform(request);
    }
}
