package ru.yandex.direct.api.v5.entity.clients.service;

import ru.yandex.direct.core.entity.client.model.Client;
import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.model.ModelChanges;

/**
 * Представление изменений одновременно в модели пользователя и клиента
 */
class UserClientChanges {
    private final ModelChanges<User> userChanges;
    private final ModelChanges<Client> clientChanges;

    UserClientChanges(ModelChanges<User> userChanges, ModelChanges<Client> clientChanges) {
        this.userChanges = userChanges;
        this.clientChanges = clientChanges;
    }

    ModelChanges<User> getUserChanges() {
        return userChanges;
    }

    ModelChanges<Client> getClientChanges() {
        return clientChanges;
    }
}
