package ru.yandex.direct.api.v5.entity.creatives;

import ru.yandex.direct.api.v5.common.validation.DefaultApiPresentations;
import ru.yandex.direct.api.v5.common.validation.DefectPresentationsHolder;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.core.entity.creative.service.add.validation.CreativeDefectIds;

import static ru.yandex.direct.api.v5.validation.DefectTypes.invalidValue;

public class CreativesDefectTypes {
    public static final DefectPresentationsHolder DEFECT_PRESENTATIONS = DefectPresentationsHolder
            .builderWithFallback(DefaultApiPresentations.HOLDER)
            .register(CreativeDefectIds.Gen.CREATE_ADDITION_FROM_VIDEO_FAILED, createAdditionFromVideoFailed())
            .build();

    private static CreativesDefectTranslations translations() {
        return CreativesDefectTranslations.INSTANCE;
    }

    public static DefectType createAdditionFromVideoFailed() {
        return invalidValue()
                .withDetailedMessage(translations().createAdditionFromVideoFailed());
    }
}
