package ru.yandex.direct.api.v5.entity.creatives;

import com.yandex.direct.api.v5.creatives.AddRequest;
import com.yandex.direct.api.v5.creatives.AddResponse;
import com.yandex.direct.api.v5.creatives.ApiException;
import com.yandex.direct.api.v5.creatives.CreativesPort;
import com.yandex.direct.api.v5.creatives.GetRequest;
import com.yandex.direct.api.v5.creatives.GetResponse;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.api.v5.entity.GenericApiService;
import ru.yandex.direct.api.v5.entity.creatives.delegate.AddCreativesDelegate;
import ru.yandex.direct.api.v5.entity.creatives.delegate.GetCreativesDelegate;
import ru.yandex.direct.api.v5.ws.annotation.ApiMethod;
import ru.yandex.direct.api.v5.ws.annotation.ApiRequest;
import ru.yandex.direct.api.v5.ws.annotation.ApiResponse;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceEndpoint;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceType;
import ru.yandex.direct.api.v5.ws.annotation.ServiceType;
import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;

@ApiServiceEndpoint
@ApiServiceType(type = ServiceType.CLIENT)
public class CreativesEndpoint implements CreativesPort {
    private static final String SERVICE_NAME = "creatives";

    private final GenericApiService genericApiService;
    private final AddCreativesDelegate addCreativesDelegate;
    private final GetCreativesDelegate getCreativesDelegate;

    @Autowired
    public CreativesEndpoint(GenericApiService genericApiService,
                             AddCreativesDelegate addCreativesDelegate,
                             GetCreativesDelegate getCreativesDelegate) {
        this.genericApiService = genericApiService;
        this.addCreativesDelegate = addCreativesDelegate;
        this.getCreativesDelegate = getCreativesDelegate;
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "add")
    @ApiResponse
    @Override
    public AddResponse add(@ApiRequest AddRequest addRequest) {
        return genericApiService.doAction(addCreativesDelegate, addRequest);
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "get")
    @ApiResponse
    @Override
    public GetResponse get(@ApiRequest GetRequest parameters) throws ApiException {
        return genericApiService.doAction(getCreativesDelegate, parameters);
    }
}
