package ru.yandex.direct.api.v5.entity.creatives.converter;

import java.util.List;

import com.yandex.direct.api.v5.creatives.AddRequest;
import com.yandex.direct.api.v5.creatives.CreativeAddItem;

import ru.yandex.direct.core.entity.creative.service.CreativeService;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public class AddRequestConverter {
    public static List<CreativeService.VideoItem> convert(AddRequest addRequest) {
        List<CreativeAddItem> creatives = addRequest.getCreatives();
        return mapList(creatives, AddRequestConverter::convert);
    }

    private static CreativeService.VideoItem convert(CreativeAddItem item) {
        if (item.getVideoExtensionCreative() != null) {
            var videoExtensionCreative = item.getVideoExtensionCreative();
            return new CreativeService.VideoItem(videoExtensionCreative.getVideoId());
        } else {
            throw new UnsupportedOperationException("Unexpected creative type");
        }
    }
}
