package ru.yandex.direct.api.v5.entity.creatives.converter;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.common.collect.ImmutableMap;
import com.yandex.direct.api.v5.creatives.CreativeTypeEnum;
import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.creative.model.CreativeType;

import static one.util.streamex.MoreCollectors.toEnumSet;


public class GetRequestConverter {

    public static final Map<CreativeTypeEnum, CreativeType> EXTERNAL_TO_INTERNAL_TYPE =
            ImmutableMap.<CreativeTypeEnum, CreativeType>builder()
                    .put(CreativeTypeEnum.IMAGE_CREATIVE, CreativeType.CANVAS)
                    .put(CreativeTypeEnum.HTML_5_CREATIVE, CreativeType.HTML5_CREATIVE)
                    .put(CreativeTypeEnum.VIDEO_EXTENSION_CREATIVE, CreativeType.VIDEO_ADDITION_CREATIVE)
                    .put(CreativeTypeEnum.CPC_VIDEO_CREATIVE, CreativeType.CPC_VIDEO_CREATIVE)
                    .put(CreativeTypeEnum.CPM_VIDEO_CREATIVE, CreativeType.CPM_VIDEO_CREATIVE)
                    .put(CreativeTypeEnum.SMART_CREATIVE, CreativeType.PERFORMANCE)
                    .build();

    public static Set<CreativeType> convertTypes(List<CreativeTypeEnum> externalTypes) {
        return StreamEx.of(externalTypes)
                .map(EXTERNAL_TO_INTERNAL_TYPE::get)
                .nonNull()
                .collect(toEnumSet(CreativeType.class));
    }
}
