package ru.yandex.direct.api.v5.entity.creatives.delegate;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.creatives.AddRequest;
import com.yandex.direct.api.v5.creatives.AddResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.api.v5.common.ApiPathConverter;
import ru.yandex.direct.api.v5.converter.ResultConverter;
import ru.yandex.direct.api.v5.entity.OperationOnListDelegate;
import ru.yandex.direct.api.v5.entity.creatives.converter.AddRequestConverter;
import ru.yandex.direct.api.v5.entity.creatives.validation.AddCreativesValidationService;
import ru.yandex.direct.api.v5.result.ApiMassResult;
import ru.yandex.direct.api.v5.result.ApiResult;
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.core.entity.creative.service.CreativeService;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.api.v5.entity.creatives.CreativesDefectTypes.DEFECT_PRESENTATIONS;

@Service
@ParametersAreNonnullByDefault
public class AddCreativesDelegate
        extends OperationOnListDelegate<AddRequest, AddResponse, CreativeService.VideoItem, Long> {
    private final AddCreativesValidationService validationService;
    private final ResultConverter resultConverter;
    private final CreativeService creativeService;

    @Autowired
    public AddCreativesDelegate(
            ApiAuthenticationSource auth,
            AddCreativesValidationService validationService,
            ResultConverter resultConverter,
            CreativeService creativeService) {
        super(ApiPathConverter.forCreatives(), auth);
        this.validationService = validationService;
        this.resultConverter = resultConverter;
        this.creativeService = creativeService;
    }

    @Nullable
    @Override
    public ValidationResult<AddRequest, DefectType> validateRequest(AddRequest addRequest) {
        return validationService.validateRequest(addRequest);
    }

    @Override
    public List<CreativeService.VideoItem> convertRequest(AddRequest addRequest) {
        return AddRequestConverter.convert(addRequest);
    }

    @Override
    public ApiMassResult<Long> processList(List<CreativeService.VideoItem> validItems) {
        var clientId = auth.getChiefSubclient().getClientId();
        MassResult<Long> result = creativeService.createDefaultAdditionsFromVideoIds(clientId, validItems);
        return resultConverter.toApiMassResult(result, DEFECT_PRESENTATIONS);
    }

    @Override
    public AddResponse convertResponse(ApiResult<List<ApiResult<Long>>> result) {
        return new AddResponse().withAddResults(resultConverter.toActionResults(result, apiPathConverter));
    }
}
