package ru.yandex.direct.api.v5.entity.creatives.validation;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.creatives.AddRequest;
import com.yandex.direct.api.v5.creatives.CreativeAddItem;
import com.yandex.direct.api.v5.creatives.VideoExtensionCreativeAddItem;
import org.springframework.stereotype.Service;

import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.api.v5.entity.creatives.Constants.MAX_ELEMENTS_PER_ADD;
import static ru.yandex.direct.api.v5.validation.DefectTypes.maxElementsPerRequest;
import static ru.yandex.direct.api.v5.validation.constraints.Constraints.maxListSize;
import static ru.yandex.direct.api.v5.validation.constraints.Constraints.notNull;

@Service
@ParametersAreNonnullByDefault
public class AddCreativesValidationService {
    public ValidationResult<AddRequest, DefectType> validateRequest(AddRequest addRequest) {
        ItemValidationBuilder<AddRequest, DefectType> vb = ItemValidationBuilder.of(addRequest);

        ListValidationBuilder<CreativeAddItem, DefectType> lvb =
                vb.list(addRequest.getCreatives(), AddRequest.PropInfo.CREATIVES.propertyName);
        lvb.checkEach(notNull())
                .check(maxListSize(MAX_ELEMENTS_PER_ADD), maxElementsPerRequest(MAX_ELEMENTS_PER_ADD))
                .checkEachBy(this.validateAddItem(), When.notNull());
        return vb.getResult();
    }

    private Validator<CreativeAddItem, DefectType> validateAddItem() {
        return addItem -> {
            ItemValidationBuilder<CreativeAddItem, DefectType> v = ItemValidationBuilder.of(addItem);
            v.item(addItem.getVideoExtensionCreative(), CreativeAddItem.PropInfo.VIDEO_EXTENSION_CREATIVE.propertyName)
                    .check(notNull())
                    .checkBy(validateVideoExtensionAddItem(), When.isValid());

            return v.getResult();
        };
    }

    private Validator<VideoExtensionCreativeAddItem, DefectType> validateVideoExtensionAddItem() {
        return addItem -> {
            ItemValidationBuilder<VideoExtensionCreativeAddItem, DefectType> v = ItemValidationBuilder.of(addItem);
            v.item(addItem.getVideoId(), VideoExtensionCreativeAddItem.PropInfo.VIDEO_ID.propertyName)
                    .check(notNull());

            return v.getResult();
        };
    }
}
