package ru.yandex.direct.api.v5.entity.dictionaries;

import com.yandex.direct.api.v5.dictionaries.ApiException;
import com.yandex.direct.api.v5.dictionaries.DictionariesPort;
import com.yandex.direct.api.v5.dictionaries.GetRequest;
import com.yandex.direct.api.v5.dictionaries.GetResponse;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.api.v5.ws.annotation.ApiMethod;
import ru.yandex.direct.api.v5.ws.annotation.ApiRequest;
import ru.yandex.direct.api.v5.ws.annotation.ApiResponse;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceEndpoint;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceType;
import ru.yandex.direct.api.v5.ws.annotation.ServiceType;
import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;

@ApiServiceEndpoint
@ApiServiceType(type = ServiceType.ALL)
public class DictionariesEndpoint implements DictionariesPort {
    private static final String SERVICE_NAME = "dictionaries";

    private final DictionariesService dictionariesService;

    @Autowired
    public DictionariesEndpoint(DictionariesService dictionariesService) {
        this.dictionariesService = dictionariesService;
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "get")
    @ApiResponse
    @Override
    public GetResponse get(@ApiRequest GetRequest getRequest) throws ApiException {
        return dictionariesService.get(getRequest);
    }
}
