package ru.yandex.direct.api.v5.entity.dictionaries.categories;

import java.util.Map;

import com.google.common.collect.ImmutableMap;

import ru.yandex.direct.i18n.Translatable;

import static ru.yandex.direct.core.entity.banner.model.BannerFlags.ABORTION;
import static ru.yandex.direct.core.entity.banner.model.BannerFlags.ALCOHOL;
import static ru.yandex.direct.core.entity.banner.model.BannerFlags.BABY_FOOD;
import static ru.yandex.direct.core.entity.banner.model.BannerFlags.DIETARYSUPPL;
import static ru.yandex.direct.core.entity.banner.model.BannerFlags.MEDICINE;
import static ru.yandex.direct.core.entity.banner.model.BannerFlags.PROJECT_DECLARATION;
import static ru.yandex.direct.core.entity.banner.model.BannerFlags.PSEUDOWEAPON;
import static ru.yandex.direct.core.entity.banner.model.BannerFlags.TOBACCO;

/**
 * Содержит соответствие валюты и её текстового представления
 */
public class CategoryTranslationHolder {
    private static final Map<String, CategoryTranslation> CATEGORY_PRESENTATION_BY_CODE =
            initCategoryPresentationByCategory();

    private CategoryTranslationHolder() {
    }

    /**
     * Метод возвращает перевод для конкретной категории
     *
     * @param category категория
     * @throws IllegalArgumentException если перевод для категории не найден
     */
    public static CategoryTranslation ofCategory(String category) {
        CategoryTranslation categoryTranslation = CATEGORY_PRESENTATION_BY_CODE.get(category);
        if (categoryTranslation == null) {
            throw new IllegalArgumentException("There is no translation for this category: " + category);
        }
        return categoryTranslation;
    }

    private static Map<String, CategoryTranslation> initCategoryPresentationByCategory() {
        CategoriesTranslations t = translations();
        return ImmutableMap.<String, CategoryTranslation>builder()
                .put(ABORTION.getKey(), translation(t.abortionShort(), t.abortionFull()))
                .put(MEDICINE.getKey(), translation(t.medicineShort(), t.medicineFull()))
                .put(ALCOHOL.getKey(), translation(t.alcoholShort(), t.alcoholFull()))
                .put(TOBACCO.getKey(), translation(t.tobaccoShort(), t.tobaccoFull()))
                .put(BABY_FOOD.getKey(), translation(t.babyFoodShort(), t.babyFoodFull()))
                .put(DIETARYSUPPL.getKey(), translation(t.dietarySupplementsShort(), t.dietarySupplementsFull()))
                .put(PROJECT_DECLARATION.getKey(), translation(t.projectDeclarationShort(), t.projectDeclarationFull()))
                .put(PSEUDOWEAPON.getKey(), translation(t.pseudoWeaponShort(), t.pseudoWeaponFull()))
                .build();
    }

    private static CategoryTranslation translation(Translatable description, Translatable message) {
        return new CategoryTranslation(description, message);
    }

    private static CategoriesTranslations translations() {
        return CategoriesTranslations.INSTANCE;
    }
}
