package ru.yandex.direct.api.v5.entity.dictionaries.crypta;

import java.util.Arrays;
import java.util.stream.Collectors;

import javax.annotation.Nullable;

import com.google.common.collect.ImmutableMap;

import ru.yandex.direct.core.entity.retargeting.model.GoalType;

import static ru.yandex.direct.core.entity.retargeting.model.GoalType.BEHAVIORS;
import static ru.yandex.direct.core.entity.retargeting.model.GoalType.FAMILY;
import static ru.yandex.direct.core.entity.retargeting.model.GoalType.SOCIAL_DEMO;

public enum BlockElementType {
    SOCIAL(SOCIAL_DEMO),

    EXTENDED_SOCIAL(FAMILY),

    BEHAVIORAL_INDICATORS(BEHAVIORS);

    private static final ImmutableMap<GoalType, BlockElementType> ENUMS = ImmutableMap.copyOf(
            Arrays.stream(values())
                    .collect(Collectors.toMap(BlockElementType::getTypedValue, e -> e)));

    private final GoalType typedValue;

    BlockElementType(GoalType typedValue) {
        this.typedValue = typedValue;
    }

    public GoalType getTypedValue() {
        return typedValue;
    }

    public static BlockElementType fromTypedValue(@Nullable GoalType typedValue) {
        BlockElementType result = ENUMS.get(typedValue);
        if (result == null) {
            throw new IllegalArgumentException("Unknown enum typed value " + typedValue);
        }
        return result;
    }
}
