package ru.yandex.direct.api.v5.entity.dictionaries.validation;

import org.apache.logging.log4j.util.Strings;

import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.validation.builder.Constraint;

import static ru.yandex.direct.api.v5.entity.dictionaries.validation.DictionariesDefectTypes.clientsMustUseNewVersionOfAndroidApplication;

public class DictionariesConstraints {

    public static Constraint<String, DefectType> mustUseNewVersionOfAndroidApplication() {
        return version -> Strings.isBlank(version) ? clientsMustUseNewVersionOfAndroidApplication() : null;
    }
}
