package ru.yandex.direct.api.v5.entity.dynamicfeedadtargets;

import ru.yandex.direct.api.v5.common.validation.DefaultApiPresentations;
import ru.yandex.direct.api.v5.common.validation.DefectPresentationsHolder;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.api.v5.validation.DefectTypes;
import ru.yandex.direct.core.entity.bids.validation.BidsDefects;
import ru.yandex.direct.core.entity.dynamictextadtarget.service.validation.DynamicTextAdTargetDefectIds;
import ru.yandex.direct.core.entity.performancefilter.service.PerformanceFilterDefects;
import ru.yandex.direct.i18n.types.Identity;
import ru.yandex.direct.validation.defect.ids.CollectionDefectIds;
import ru.yandex.direct.validation.result.DefectIds;

import static ru.yandex.direct.api.v5.entity.bids.validation.BidsDefectTypes.bidMustBeNotGreaterThan;
import static ru.yandex.direct.api.v5.entity.bids.validation.BidsDefectTypes.bidMustBeNotLessThan;
import static ru.yandex.direct.api.v5.entity.bids.validation.BidsDefectTypes.bidNetworkWontBeAcceptedContextDependsOnSearch;
import static ru.yandex.direct.api.v5.entity.bids.validation.BidsDefectTypes.bidWontBeAcceptedInCaseOfAutoBudgetStrategy;
import static ru.yandex.direct.api.v5.entity.bids.validation.BidsDefectTypes.bidWontBeAcceptedInCaseOfContextIsServingOff;
import static ru.yandex.direct.api.v5.entity.bids.validation.BidsDefectTypes.priorityWontBeAcceptedNotAutoBudgetStrategy;
import static ru.yandex.direct.api.v5.entity.bids.validation.BidsDefectTypes.searchBidWontBeAcceptedSearchIsSwitchedOff;
import static ru.yandex.direct.api.v5.entity.dynamictextadtargets.DynamicAdTargetsDefectTypes.adGroupNotFound;
import static ru.yandex.direct.api.v5.entity.dynamictextadtargets.DynamicAdTargetsDefectTypes.allPageConditionCantBeWithAnotherCondition;
import static ru.yandex.direct.api.v5.entity.dynamictextadtargets.DynamicAdTargetsDefectTypes.duplicateRulesInConditions;
import static ru.yandex.direct.api.v5.entity.dynamictextadtargets.DynamicAdTargetsDefectTypes.dynamicConditionAlreadyExists;
import static ru.yandex.direct.api.v5.entity.dynamictextadtargets.DynamicAdTargetsDefectTypes.dynamicTextAdTargetsNotFound;
import static ru.yandex.direct.api.v5.entity.dynamictextadtargets.DynamicAdTargetsDefectTypes.exceededMaxLengthInArguments;
import static ru.yandex.direct.api.v5.entity.dynamictextadtargets.DynamicAdTargetsDefectTypes.exceededMaxLengthInName;
import static ru.yandex.direct.api.v5.entity.dynamictextadtargets.DynamicAdTargetsDefectTypes.invalidAdGroupType;
import static ru.yandex.direct.api.v5.entity.dynamictextadtargets.DynamicAdTargetsDefectTypes.invalidEmptyNameFormat;
import static ru.yandex.direct.api.v5.entity.dynamictextadtargets.DynamicAdTargetsDefectTypes.invalidEmptyUrlFormat;
import static ru.yandex.direct.api.v5.entity.dynamictextadtargets.DynamicAdTargetsDefectTypes.invalidIdInField;
import static ru.yandex.direct.api.v5.entity.dynamictextadtargets.DynamicAdTargetsDefectTypes.invalidLettersInName;
import static ru.yandex.direct.api.v5.entity.dynamictextadtargets.DynamicAdTargetsDefectTypes.invalidLettersInRule;
import static ru.yandex.direct.api.v5.entity.dynamictextadtargets.DynamicAdTargetsDefectTypes.invalidUrlFormat;
import static ru.yandex.direct.api.v5.entity.dynamictextadtargets.DynamicAdTargetsDefectTypes.numberOfArgumentsInRule;
import static ru.yandex.direct.api.v5.entity.smartadtargets.defects.SmartAdTargetDefectTypes.filterConditionsIsTooLong;
import static ru.yandex.direct.api.v5.entity.smartadtargets.defects.SmartAdTargetDefectTypes.inconsistentCampaignStrategy;
import static ru.yandex.direct.api.v5.entity.smartadtargets.defects.SmartAdTargetDefectTypes.invalidOperator;
import static ru.yandex.direct.api.v5.entity.smartadtargets.defects.SmartAdTargetDefectTypes.mustContainAnyMoreConditions;
import static ru.yandex.direct.api.v5.entity.smartadtargets.defects.SmartAdTargetDefectTypes.unknownField;
import static ru.yandex.direct.api.v5.entity.smartadtargets.defects.SmartAdTargetDefectTypes.unknownOperator;
import static ru.yandex.direct.api.v5.validation.DefectTypes.notEligibleObject;

public class DynamicFeedAdTargetsDefectTypes {
    public static final DefectPresentationsHolder DEFECT_PRESENTATIONS = DefectPresentationsHolder
            .builderWithFallback(DefaultApiPresentations.HOLDER)
            .register(DefectIds.OBJECT_NOT_FOUND, dynamicTextAdTargetsNotFound())
            .register(DefectIds.MUST_BE_VALID_ID, invalidIdInField())
            .register(DefectIds.INCONSISTENT_STATE, invalidAdGroupType())
            .register(DefectIds.INCONSISTENT_STATE_ALREADY_EXISTS, dynamicConditionAlreadyExists())
            .register(CollectionDefectIds.Gen.MUST_NOT_CONTAIN_DUPLICATED_ELEMENTS, duplicateRulesInConditions())
            // Performance filter defects
            .register(PerformanceFilterDefects.PerformanceFilterDefectIds.FILTER_CONDITIONS_IS_TOO_LONG,
                    t -> filterConditionsIsTooLong())
            .register(PerformanceFilterDefects.PerformanceFilterDefectIds.INCONSISTENT_CAMPAIGN_STRATEGY,
                    t -> inconsistentCampaignStrategy())
            .register(PerformanceFilterDefects.PerformanceFilterDefectIds.INVALID_OPERATOR, t -> invalidOperator())
            .register(PerformanceFilterDefects.PerformanceFilterDefectIds.MUST_CONTAIN_ANY_MORE_CONDITIONS,
                    t -> mustContainAnyMoreConditions())
            .register(PerformanceFilterDefects.PerformanceFilterDefectIds.UNKNOWN_FIELD, t -> unknownField())
            .register(PerformanceFilterDefects.PerformanceFilterDefectIds.UNKNOWN_OPERATOR, t -> unknownOperator())
            // Dynamic text/feed ad target defects
            .register(DynamicTextAdTargetDefectIds.Strings.NUMBER_ARGUMENTS_MUST_BE_FROM_TO,
                    t -> numberOfArgumentsInRule(t.getId1().intValue(), t.getMin().intValue(), t.getMax().intValue()))
            .register(DynamicTextAdTargetDefectIds.Strings.EXCEEDED_MAX_LENGTH_IN_ARGUMENTS,
                    t -> exceededMaxLengthInArguments(t.getId1().intValue(), t.getId2().intValue(),
                            t.getMax().intValue()))
            .register(DynamicTextAdTargetDefectIds.Strings.INVALID_URL_FORMAT,
                    t -> invalidUrlFormat(t.getId1().intValue(), t.getId2().intValue()))
            .register(DynamicTextAdTargetDefectIds.Strings.INVALID_EMPTY_URL_FORMAT,
                    t -> invalidEmptyUrlFormat(t.getId1().intValue(), t.getId2().intValue()))
            .register(DynamicTextAdTargetDefectIds.Strings.INVALID_LETTERS_IN_RULE,
                    t -> invalidLettersInRule(t.getId1().intValue(), t.getId2().intValue()))
            .register(DynamicTextAdTargetDefectIds.Strings.EXCEEDED_MAX_LENGTH_IN_NAME,
                    t -> exceededMaxLengthInName(t.getMax().intValue()))
            .register(DynamicTextAdTargetDefectIds.Strings.INVALID_EMPTY_NAME_FORMAT,
                    t -> invalidEmptyNameFormat())
            .register(DynamicTextAdTargetDefectIds.Strings.INVALID_LETTERS_IN_NAME,
                    t -> invalidLettersInName())
            .register(DynamicTextAdTargetDefectIds.Gen.ALL_PAGE_CONDITION_NOT_WITH_ANOTHER,
                    t -> allPageConditionCantBeWithAnotherCondition())
            .register(DynamicTextAdTargetDefectIds.Gen.NOT_ACCEPTABLE_AD_GROUP_TYPE,
                    t -> textWebpageAdGroupTypeNotSupported())
            .register(DynamicTextAdTargetDefectIds.Gen.AD_GROUP_NOT_FOUND,
                    t -> adGroupNotFound())
            .register(DynamicTextAdTargetDefectIds.Gen.DUPLICATE_RULES_IN_CONDITION,
                    t -> duplicateRulesInConditions())
            // Bids defects
            .register(BidsDefects.Ids.BID_FOR_SEARCH_WONT_BE_ACCEPTED_IN_CASE_OF_AUTOBUDGET_STRATEGY,
                    t -> bidWontBeAcceptedInCaseOfAutoBudgetStrategy())
            .register(BidsDefects.Ids.PRIORITY_WONT_BE_ACCEPTED_IN_CASE_OF_NOT_AUTO_BUDGET_STRATEGY,
                    t -> priorityWontBeAcceptedNotAutoBudgetStrategy())
            .register(BidsDefects.Ids.BID_FOR_CONTEXT_WONT_BE_ACCEPTED_NET_IS_SWITCHED_OFF,
                    t -> bidWontBeAcceptedInCaseOfContextIsServingOff())
            .register(BidsDefects.CurrencyAmountDefects.SEARCH_PRICE_IS_NOT_GREATER_THAN_MIN,
                    t -> bidMustBeNotLessThan(t.getMoneyValue().getCurrencyCode().getTranslation().longForm(),
                            Identity.of(t.getMoneyValue().micros())))
            .register(BidsDefects.CurrencyAmountDefects.SEARCH_PRICE_IS_NOT_SMALLER_THAN_MAX,
                    t -> bidMustBeNotGreaterThan(
                            t.getMoneyValue().getCurrencyCode().getTranslation().longForm(),
                            Identity.of(t.getMoneyValue().micros())))
            .register(BidsDefects.Ids.BID_FOR_SEARCH_WONT_BE_ACCEPTED_SEARCH_IS_SWITCHED_OFF,
                    t -> searchBidWontBeAcceptedSearchIsSwitchedOff())
            .register(BidsDefects.Ids.BID_FOR_CONTEXT_WONT_BE_ACCEPTED_NOT_DIFFERENT_PLACES,
                    t -> bidNetworkWontBeAcceptedContextDependsOnSearch())
            .build();

    public static DefectType textWebpageAdGroupTypeNotSupported() {
        return notEligibleObject()
                .withDetailedMessage(translations().textWebpageAdGroupTypeNotSupportedDetailed());
    }

    private static DynamicFeedAdTargetsDefectTranslations translations() {
        return DynamicFeedAdTargetsDefectTranslations.INSTANCE;
    }

    public static DefectType adGroupWithoutFeed() {
        return DefectTypes.maxIdsInSelection()
                .withDetailedMessage(translations().adGroupWithoutFeed());
    }
}
